/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.apollo.listener;

import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.fshows.fsframework.core.utils.LogUtil;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerLevelConfigChangeListener {
    private static final Logger log = LoggerFactory.getLogger(LoggerLevelConfigChangeListener.class);
    private static final String LOGGER_LEVEL_PREFIX = "logger.level";

    @ApolloConfigChangeListener
    public void loggerLevelChange(ConfigChangeEvent changeEvent) {
        Set changeKeySet = changeEvent.changedKeys();
        Set loggerChangeKeySet = changeKeySet.stream().filter(it -> it.startsWith(LOGGER_LEVEL_PREFIX)).collect(Collectors.toSet());
        for (String key : loggerChangeKeySet) {
            String oldValue;
            String newValue;
            ConfigChange change = changeEvent.getChange(key);
            if (change == null || change.getChangeType().equals((Object)PropertyChangeType.DELETED) || (newValue = change.getNewValue()).equals(oldValue = change.getOldValue())) continue;
            String loggerName = "Root";
            Level level = Level.getLevel((String)newValue.toUpperCase());
            if (key.equals(LOGGER_LEVEL_PREFIX)) {
                Configurator.setRootLevel((Level)level);
            } else {
                loggerName = key.replace("logger.level.", "");
                Configurator.setLevel((String)loggerName, (Level)level);
            }
            LogUtil.info((Logger)log, (String)"{} \u65e5\u5fd7\u7ea7\u522b\u53d8\u66f4 {} to {}", (Object[])new Object[]{loggerName, oldValue, newValue});
        }
    }
}

