/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.idgen.impl;

import com.fshows.fsframework.core.utils.FsDateUtil;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.idgen.BitsAllocator;
import com.fshows.fsframework.extend.idgen.IdGenerator;
import com.fshows.fsframework.extend.idgen.exception.IdGenerateException;
import com.fshows.fsframework.extend.idgen.worker.WorkerIdAssigner;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultIdGenerator
implements IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultIdGenerator.class);
    protected short timeBits = (short)40;
    protected short workerBits = (short)12;
    protected short seqBits = (short)11;
    protected String epochStr = "2018-01-01";
    protected long epochSeconds = 1514736000000L;
    protected BitsAllocator bitsAllocator;
    protected long workerId;
    protected long sequence = 0L;
    protected long lastSecond = -1L;
    protected short sequenceLength = (short)4;
    protected short workerIdLength = (short)4;
    protected short customerDataLength = (short)3;
    protected WorkerIdAssigner workerIdAssigner;

    @Override
    public String getId(String exData) {
        try {
            return this.nextStrId(exData);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"Generate unique id exception {}", (Throwable)e);
            throw new IdGenerateException(e);
        }
    }

    @PostConstruct
    public void init() {
        this.bitsAllocator = new BitsAllocator(this.timeBits, this.workerBits, this.seqBits);
        this.workerId = this.workerIdAssigner.assignWorkerId();
        LogUtil.info((Logger)log, (String)"worker id is {}", (Object[])new Object[]{this.workerId});
        if (this.workerId > this.bitsAllocator.getMaxWorkerId()) {
            throw new IdGenerateException(MessageFormat.format("worker id is illegal,workerid={0},max workerId={1}", this.workerId, this.bitsAllocator.getMaxWorkerId()));
        }
        LogUtil.info((Logger)log, (String)"init bits(1,{},{},{})", (Object[])new Object[]{this.timeBits, this.workerBits, this.seqBits});
    }

    private synchronized String nextStrId(String exData) {
        if (StringUtils.isBlank((CharSequence)exData) || exData.length() != this.customerDataLength) {
            throw new IllegalArgumentException("exData's length must be 3");
        }
        long currentMillSeconds = this.getCurrentMillSeconds();
        if (currentMillSeconds < this.lastSecond) {
            long refusedSeconds = this.lastSecond - currentMillSeconds;
            throw new IdGenerateException("Clock moved backwards. Refusing for %d seconds", refusedSeconds);
        }
        if (currentMillSeconds == this.lastSecond) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentMillSeconds = this.getNextMillSeconds(this.lastSecond);
            }
        } else {
            this.sequence = RandomUtils.nextLong((long)0L, (long)9L);
        }
        this.lastSecond = currentMillSeconds;
        return DateFormatUtils.format((long)currentMillSeconds, (String)"yyyyMMddHHmmssSSS") + exData + StringUtils.leftPad((String)String.valueOf(this.workerId), (int)this.workerIdLength, (char)'0') + StringUtils.leftPad((String)String.valueOf(this.sequence), (int)this.sequenceLength, (char)'0');
    }

    private long getCurrentMillSeconds() {
        long currentSecond = SystemClock.millisClock().now();
        if (currentSecond - this.epochSeconds > this.bitsAllocator.getMaxDeltaSeconds()) {
            throw new IdGenerateException("Timestamp bits is exhausted. Refusing UID generate. Now: " + currentSecond);
        }
        return currentSecond;
    }

    private long getNextMillSeconds(long lastTimestamp) {
        long timestamp = this.getCurrentMillSeconds();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentMillSeconds();
        }
        return timestamp;
    }

    public void setWorkerIdAssigner(WorkerIdAssigner workerIdAssigner) {
        this.workerIdAssigner = workerIdAssigner;
    }

    public void setTimeBits(short timeBits) {
        this.timeBits = timeBits;
    }

    public void setWorkerBits(short workerBits) {
        this.workerBits = workerBits;
    }

    public void setSeqBits(short seqBits) {
        this.seqBits = seqBits;
    }

    public void setEpochStr(String epochStr) {
        if (StringUtils.isNotBlank((CharSequence)epochStr)) {
            Date epochDate;
            this.epochStr = epochStr;
            try {
                epochDate = FsDateUtil.parseDate((String)epochStr, (String)"yyyy-MM-dd");
            }
            catch (Exception ex) {
                epochDate = new Date();
                LogUtil.error((Logger)log, (String)"epochstr date format error it must be yyyy-MM-dd", (Throwable)ex);
            }
            this.epochSeconds = TimeUnit.MILLISECONDS.toSeconds(epochDate.getTime());
        }
    }

    public void setSequenceLength(short sequenceLength) {
        this.sequenceLength = sequenceLength;
    }

    public void setWorkerIdLength(short workerIdLength) {
        this.workerIdLength = workerIdLength;
    }

    public void setCustomerDataLength(short customerDataLength) {
        this.customerDataLength = customerDataLength;
    }
}

