/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.fshows.fsframework.common.annotation.NoGlobalLog;
import com.fshows.fsframework.common.exception.BaseException;
import com.fshows.fsframework.common.exception.CommonException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.core.utils.TraceIdGenerator;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Activate(group={"provider", "consumer"}, order=-9999)
public class GlobalTraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalTraceFilter.class);
    public static final String TRACE_ID = "TRACE_ID";

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String traceId;
        String mdcTraceId = MDC.get((String)TRACE_ID);
        String string = traceId = StringUtils.isNotBlank((CharSequence)mdcTraceId) ? mdcTraceId : invocation.getAttachment(TRACE_ID);
        if (!StringUtils.isBlank((CharSequence)traceId)) {
            RpcContext.getContext().setAttachment(TRACE_ID, traceId);
        } else {
            traceId = TraceIdGenerator.generate();
            RpcContext.getContext().setAttachment(TRACE_ID, traceId);
        }
        MDC.put((String)TRACE_ID, (String)traceId);
        String methodName = invoker.getUrl().getPath();
        boolean isLog = false;
        try {
            Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
            NoGlobalLog noGlobalLog = method.getAnnotation(NoGlobalLog.class);
            isLog = noGlobalLog == null;
            methodName = methodName + "." + method.getName();
        }
        catch (NoSuchMethodException e) {
            LogUtil.error((Logger)log, (String)"\u65b9\u6cd5: invoke \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: invoker = {}, invocation = {} ,\u5f02\u5e38: Ex = {}", (Object[])new Object[]{invoker, invocation, e});
        }
        long startTime = SystemClock.millisClock().now();
        if (isLog) {
            Object[] arguments = invocation.getArguments();
            LogUtil.info((Logger)log, (String)"RPC \u63a5\u53e3\u5f00\u59cb methodName = {}, agruments = {}", (Object[])new Object[]{methodName, arguments});
        }
        Result result = invoker.invoke(invocation);
        if (isLog) {
            Throwable exception = result.getException();
            Object value = result.getValue();
            if (exception != null) {
                LogUtil.error((Logger)log, (String)"RPC \u63a5\u53e3\u5f02\u5e38\u7ed3\u675f methodName = {},  exception = {}, time = {}ms ", (Throwable)exception, (Object[])new Object[]{methodName, exception, SystemClock.millisClock().now() - startTime});
                if (!(exception instanceof BaseException)) {
                    LogUtil.error((Logger)log, (String)"RPC \u63a5\u53e3\u5f02\u5e38\u7ed3\u675f methodName = {},  exception = {}, time = {}ms ", (Object[])new Object[]{methodName, exception, SystemClock.millisClock().now() - startTime});
                    MDC.remove((String)TRACE_ID);
                    return new RpcResult((Throwable)CommonException.SYSTEM_ERROR);
                }
            } else {
                LogUtil.info((Logger)log, (String)"RPC \u63a5\u53e3\u7ed3\u675f methodName = {},  result ={}, time = {}ms ", (Object[])new Object[]{methodName, value, SystemClock.millisClock().now() - startTime});
            }
        }
        MDC.remove((String)TRACE_ID);
        return result;
    }
}

