package com.fshows.fsframework.common.enums;

/**
 * @author liujing01
 * @version DbAffectedEnum.java, v 0.1 2018-11-08 10:07
 */
public enum DbAffectedEnum {
    /**
     * 枚举列表
     */
    ZORO_ROW("影响行数0",0),
    ONE_ROW("影响行数1",1),
    ;

    private String name;
    private Integer value;

    DbAffectedEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public Integer getValue() {
        return value;
    }

    public static DbAffectedEnum getByValue(Integer value) {
        DbAffectedEnum[] valueList = DbAffectedEnum.values();
        for (DbAffectedEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v;
            }
        }
        return null;
    }
}