/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.fshows.fsframework.common.exception;

import java.io.Serializable;
import java.text.MessageFormat;

/**
 * fs基础异常类
 * ps：老应用不要使用这个异常类，新应用可以使用!!!
 *
 * @author buhao
 * @version FsBaseException.java, v 0.1 2018-09-19 14:13 buhao
 */
public class FsBaseException extends RuntimeException implements Serializable {

    private static final long serialVersionUID = -2525983584145264509L;

    /**
     * 异常业务类型
     */
    protected String exType;

    /**
     * 异常信息
     */
    protected String msg;
    /**
     * 具体异常码
     */
    protected String code;
    /**
     * 子错误码
     */
    protected String subCode;

    /**
     * 异常构造器
     *
     * @param code      错误码
     * @param msgFormat 消息模板,内部会用MessageFormat拼接，模板类似：userid={0},message={1},date{2}
     * @param args      具体参数的值
     */
    public FsBaseException(String code, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    /**
     * 异常构造器
     *
     * @param code      错误码
     * @param subCode   子错误码
     * @param msgFormat 消息模板,内部会用MessageFormat拼接，模板类似：userid={0},message={1},date{2}
     * @param args      具体参数的值
     */
    public FsBaseException(String code, String subCode, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.subCode = subCode;
        this.msg = MessageFormat.format(msgFormat, args);
    }


    /**
     * 默认构造器
     */
    public FsBaseException() {
        super();
    }

    /**
     * 异常构造器
     *
     * @param message
     * @param cause
     */
    public FsBaseException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * 异常构造器
     *
     * @param cause
     */
    public FsBaseException(Throwable cause) {
        super(cause);
    }

    /**
     * 异常构造器
     *
     * @param message
     */
    public FsBaseException(String message) {
        super(message);
    }

    /**
     * 错误消息
     */
    public String getMsg() {
        return msg;
    }

    /**
     * 错误代码
     *
     * @return
     */
    public String getCode() {
        return code;
    }

    /**
     * 子错误码
     *
     * @return
     */
    public String getSubCode() { return subCode;}

    /**
     * 异常业务类型
     *
     * @return
     */
    public String getExType() { return exType;}

    public FsBaseException setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * msg重写
     *
     * @param msgFormat
     * @param args
     * @return
     */
    public FsBaseException newInstance(String msgFormat, Object... args) {
        this.msg = MessageFormat.format(msgFormat, args);
        return this;
    }

    /**
     * 重写堆栈填充，不填充错误堆栈信息
     *
     * @return
     */
    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    /**
     * Returns the detail message string of this throwable.
     *
     * @return the detail message string of this {@code Throwable} instance
     * (which may be {@code null}).
     */
    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }

    /**
     * 追加subCode
     *
     * @param subCode
     */
    public FsBaseException appendSubCode(String subCode) {
        this.subCode = subCode;
        return this;
    }
}


