/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.util;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.digest.SM3;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSONObject;
import com.fshows.util.fjnx.SecurityTools;
import com.fshows.util.fnefpay.exception.TransException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class GmUtils {
    public static String signAndEncrypt(Map<String, Object> head, Map<String, Object> body, String privateKey, String passWord, String publicKey) throws Exception {
        if (null == head) {
            throw new TransException("\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == body) {
            throw new TransException("\u8bf7\u6c42\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String bodyString = JSONObject.toJSONString(body);
        String digest = SM3.create().digestHex(bodyString).toUpperCase();
        SecurityTools securityTools = new SecurityTools(privateKey, passWord, publicKey);
        String signature = securityTools.sign(digest);
        String secretKey = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        String encryptedBody = new SM4(HexUtil.decodeHex((String)secretKey)).encryptHex(bodyString).toUpperCase();
        String digitalEnvelope = securityTools.digitalEnvelope(secretKey);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        HashMap<String, Object> headEncrypt = new HashMap<String, Object>();
        headEncrypt.put("merInstId", head.get("merInstId"));
        headEncrypt.put("sysInstId", head.get("sysInstId"));
        headEncrypt.put("digitalEnvelope", digitalEnvelope);
        headEncrypt.put("signature", signature);
        headEncrypt.put("signType", head.get("signType"));
        requestMap.put("head", headEncrypt);
        requestMap.put("body", encryptedBody);
        return JSONObject.toJSONString(requestMap);
    }

    public static String verifyAndDecrypt(String message, String privateKey, String password, String publicKey) throws Exception {
        HashMap map = new HashMap();
        Map parseMap = (Map)JSONObject.parseObject((String)message, map.getClass());
        Object head = parseMap.get("head");
        Object body = parseMap.get("body");
        Map headMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(head), map.getClass());
        Object digitalEnvelope = headMap.get("digitalEnvelope");
        Object signature = headMap.get("signature");
        SecurityTools securityTools = new SecurityTools(privateKey, password, publicKey);
        String secretKey = securityTools.decryptDigitalEnvelope((String)digitalEnvelope);
        String decryptedBody = new SM4(HexUtil.decodeHex((String)secretKey)).decryptStr((String)body);
        String digest = SM3.create().digestHex(decryptedBody).toUpperCase();
        if (!securityTools.verify((String)signature, digest)) {
            throw new TransException("\u9a8c\u7b7e\u5931\u8d25");
        }
        return decryptedBody;
    }
}

