/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.sdk;

import com.fshows.util.fnefpay.sdk.FnefPayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FnefPayConfig {
    public static final String FILE_NAME = "fnefpay_sdk.properties";
    private String backRequestUrl;
    private String gh11BackRequestUrl;
    private String gh12BackRequestUrl;
    private String gh13BackRequestUrl;
    private String gh21BackRequestUrl;
    private String gh22BackRequestUrl;
    private String gh23BackRequestUrl;
    private String ghzscBackRequestUrl;
    private String ghyzBackRequestUrl;
    private String connectTimeOut;
    private String readTimeOut;
    private String merchantId;
    private String terminalId;
    private Boolean ifValidateRemoteCert;
    private String signCertPath;
    private String signCertPwd;
    private String validateCertDir;
    private String validateCertSn;
    private String gmSignCertPath;
    private String gmSignCertPwd;
    private String gmVerifyCertDir;
    private String gmValidateCertSn;
    private String merInstId;
    private String signMethod;
    public static final String SDK_BACK_URL = "fnefpay.backTransUrl";
    public static final String SDK_GH11_BACK_URL = "fnefpay.gh11.backTransUrl";
    public static final String SDK_GH12_BACK_URL = "fnefpay.gh12.backTransUrl";
    public static final String SDK_GH13_BACK_URL = "fnefpay.gh13.backTransUrl";
    public static final String SDK_GH21_BACK_URL = "fnefpay.gh21.backTransUrl";
    public static final String SDK_GH22_BACK_URL = "fnefpay.gh22.backTransUrl";
    public static final String SDK_GH23_BACK_URL = "fnefpay.gh23.backTransUrl";
    public static final String SDK_GHZSC_BACK_URL = "fnefpay.ghzsc.backTransUrl";
    public static final String SDK_GHYZ_BACK_URL = "fnefpay.ghyz.backTransUrl";
    public static final String SDK_READ_TIME_OUT = "fnefpay.readTimeOut";
    public static final String SDK_CONNECT_TIME_OUT = "fnefpay.connectTimeOut";
    public static final String SDK_MERCHANT_ID = "fnefpay.merchantId";
    public static final String SDK_TERMINAL_ID = "fnefpay.terminalId";
    public static final String SDK_IF_VALIDATE_REMOTE_CERT = "fnefpay.ifValidateRemoteCert";
    public static final String SDK_SIGNCERT_PATH = "fnefpay.signCert.path";
    public static final String SDK_SIGNCERT_PWD = "fnefpay.signCert.pwd";
    public static final String SDK_SIGNCERT_TYPE = "fnefpay.signCert.type";
    public static final String SDK_VALIDATECERT_DIR = "fnefpay.validateCert.dir";
    public static final String SDK_SIGN_METHOD = "fnefpay.signMethod";
    public static final String SDK_MERINSTID = "fnefpay.merInstId";
    public static final String SDK_VALIDATECERT_SN = "fnefpay.validateCert.sn";
    private static final String SDK_GM_SIGN_CERT_PATH = "fnefpay.gmSignCert.path";
    private static final String SDK_GM_SIGN_CERT_PWD = "fnefpay.gmSignCert.pwd";
    private static final String SDK_GM_VERIFY_CERT_DIR = "fnefpay.gmVerifyCert.dir";
    public static final String SDK_GMVALIDATECERT_SN = "fnefpay.gmValidateCert.sn";
    private static FnefPayConfig config = new FnefPayConfig();
    private Properties properties;

    private FnefPayConfig() {
    }

    public static FnefPayConfig getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFromPath(String rootPath) {
        if (rootPath != null && !"".equals(rootPath.trim())) {
            File file = new File(rootPath + File.separator + FILE_NAME);
            FileInputStream in = null;
            if (file.exists()) {
                try {
                    in = new FileInputStream(file);
                    this.properties = new Properties();
                    this.properties.load(in);
                    this.loadProperties(this.properties);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    if (null != in) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            this.loadPropertiesFromSrc();
        }
    }

    public void loadPropertiesFromSrc() {
        InputStream in = null;
        try {
            in = FnefPayConfig.class.getClassLoader().getResourceAsStream(FILE_NAME);
            if (null != in) {
                this.properties = new Properties();
                this.properties.load(in);
            } else {
                return;
            }
            this.loadProperties(this.properties);
        }
        catch (IOException iOException) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadProperties(Properties pro) {
        String value = null;
        value = pro.getProperty(SDK_SIGNCERT_PATH);
        if (!FnefPayUtils.isEmpty(value)) {
            this.signCertPath = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_SIGNCERT_PWD))) {
            this.signCertPwd = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_VALIDATECERT_DIR))) {
            this.validateCertDir = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_BACK_URL))) {
            this.backRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GH11_BACK_URL))) {
            this.gh11BackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GH12_BACK_URL))) {
            this.gh12BackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GH13_BACK_URL))) {
            this.gh13BackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GH21_BACK_URL))) {
            this.gh21BackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GH22_BACK_URL))) {
            this.gh22BackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GH23_BACK_URL))) {
            this.gh23BackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GHZSC_BACK_URL))) {
            this.ghzscBackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GHYZ_BACK_URL))) {
            this.ghyzBackRequestUrl = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_CONNECT_TIME_OUT))) {
            this.connectTimeOut = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_READ_TIME_OUT))) {
            this.readTimeOut = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_MERCHANT_ID))) {
            this.merchantId = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_TERMINAL_ID))) {
            this.terminalId = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_IF_VALIDATE_REMOTE_CERT))) {
            this.ifValidateRemoteCert = "true".equals(value.trim()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_SIGN_METHOD))) {
            this.signMethod = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_MERINSTID))) {
            this.merInstId = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_VALIDATECERT_SN))) {
            this.validateCertSn = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GM_SIGN_CERT_PATH))) {
            this.gmSignCertPath = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GM_SIGN_CERT_PWD))) {
            this.gmSignCertPwd = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GM_VERIFY_CERT_DIR))) {
            this.gmVerifyCertDir = value.trim();
        }
        if (!FnefPayUtils.isEmpty(value = pro.getProperty(SDK_GMVALIDATECERT_SN))) {
            this.gmValidateCertSn = value.trim();
        }
    }

    public String getBackRequestUrl() {
        return this.backRequestUrl;
    }

    public void setBackRequestUrl(String backRequestUrl) {
        this.backRequestUrl = backRequestUrl;
    }

    public String getSignCertPath() {
        return this.signCertPath;
    }

    public void setSignCertPath(String signCertPath) {
        this.signCertPath = signCertPath;
    }

    public String getSignCertPwd() {
        return this.signCertPwd;
    }

    public void setSignCertPwd(String signCertPwd) {
        this.signCertPwd = signCertPwd;
    }

    public String getValidateCertDir() {
        return this.validateCertDir;
    }

    public void setValidateCertDir(String validateCertDir) {
        this.validateCertDir = validateCertDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public String getMerInstId() {
        return this.merInstId;
    }

    public void setMerInstId(String merInstId) {
        this.merInstId = merInstId;
    }

    public String getValidateCertSn() {
        return this.validateCertSn;
    }

    public void setValidateCertSn(String validateCertSn) {
        this.validateCertSn = validateCertSn;
    }

    public String getGh11BackRequestUrl() {
        return this.gh11BackRequestUrl;
    }

    public void setGh11BackRequestUrl(String gh11BackRequestUrl) {
        this.gh11BackRequestUrl = gh11BackRequestUrl;
    }

    public String getGh12BackRequestUrl() {
        return this.gh12BackRequestUrl;
    }

    public void setGh12BackRequestUrl(String gh12BackRequestUrl) {
        this.gh12BackRequestUrl = gh12BackRequestUrl;
    }

    public String getGh13BackRequestUrl() {
        return this.gh13BackRequestUrl;
    }

    public void setGh13BackRequestUrl(String gh13BackRequestUrl) {
        this.gh13BackRequestUrl = gh13BackRequestUrl;
    }

    public String getGh21BackRequestUrl() {
        return this.gh21BackRequestUrl;
    }

    public void setGh21BackRequestUrl(String gh21BackRequestUrl) {
        this.gh21BackRequestUrl = gh21BackRequestUrl;
    }

    public String getGh22BackRequestUrl() {
        return this.gh22BackRequestUrl;
    }

    public void setGh22BackRequestUrl(String gh22BackRequestUrl) {
        this.gh22BackRequestUrl = gh22BackRequestUrl;
    }

    public String getGh23BackRequestUrl() {
        return this.gh23BackRequestUrl;
    }

    public void setGh23BackRequestUrl(String gh23BackRequestUrl) {
        this.gh23BackRequestUrl = gh23BackRequestUrl;
    }

    public String getGhzscBackRequestUrl() {
        return this.ghzscBackRequestUrl;
    }

    public void setGhzscBackRequestUrl(String ghzscBackRequestUrl) {
        this.ghzscBackRequestUrl = ghzscBackRequestUrl;
    }

    public String getGhyzBackRequestUrl() {
        return this.ghyzBackRequestUrl;
    }

    public void setGhyzBackRequestUrl(String ghyzBackRequestUrl) {
        this.ghyzBackRequestUrl = ghyzBackRequestUrl;
    }

    public String getGmSignCertPath() {
        return this.gmSignCertPath;
    }

    public void setGmSignCertPath(String gmSignCertPath) {
        this.gmSignCertPath = gmSignCertPath;
    }

    public String getGmSignCertPwd() {
        return this.gmSignCertPwd;
    }

    public void setGmSignCertPwd(String gmSignCertPwd) {
        this.gmSignCertPwd = gmSignCertPwd;
    }

    public String getGmVerifyCertDir() {
        return this.gmVerifyCertDir;
    }

    public void setGmVerifyCertDir(String gmVerifyCertDir) {
        this.gmVerifyCertDir = gmVerifyCertDir;
    }

    public String getGmValidateCertSn() {
        return this.gmValidateCertSn;
    }

    public void setGmValidateCertSn(String gmValidateCertSn) {
        this.gmValidateCertSn = gmValidateCertSn;
    }

    public String getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(String connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public String getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(String readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public Boolean getIfValidateRemoteCert() {
        return this.ifValidateRemoteCert;
    }

    public void setIfValidateRemoteCert(Boolean ifValidateRemoteCert) {
        this.ifValidateRemoteCert = ifValidateRemoteCert;
    }
}

