/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gm;

import com.fshows.util.fnefpay.gm.SM2Params;
import java.math.BigInteger;
import shaded.org.bouncycastle.jce.interfaces.ECPublicKey;
import shaded.org.bouncycastle.jce.spec.ECParameterSpec;
import shaded.org.bouncycastle.math.ec.ECPoint;

public final class SM2PublicKey
implements ECPublicKey {
    private static final long serialVersionUID = 1L;
    private final ECParameterSpec sm2ParameterSpec = SM2Params.sm2ParameterSpec;
    private byte[] bPubX = null;
    private byte[] bPubY = null;
    private BigInteger iPubX = null;
    private BigInteger iPubY = null;
    private final ECPoint Q;
    private final byte[] zvalue;

    public SM2PublicKey(byte[] bPubX, byte[] bPubY) {
        if (bPubX == null) {
            throw new IllegalArgumentException("null not allowed for bPubX");
        }
        if (bPubY == null) {
            throw new IllegalArgumentException("null not allowed for bPubY");
        }
        this.Q = this.createPoint(null, new BigInteger(1, bPubX), new BigInteger(1, bPubY));
        this.zvalue = SM2Params.calcZ(bPubX, bPubY);
    }

    private final ECPoint createPoint(ECPoint point, BigInteger iPubX, BigInteger iPubY) {
        ECPoint Q = null;
        Q = this.sm2ParameterSpec.getCurve().createPoint(iPubX, iPubY);
        this.bPubX = SM2PublicKey.asUnsignedNByteArray(iPubX, 32);
        this.bPubY = SM2PublicKey.asUnsignedNByteArray(iPubY, 32);
        return Q;
    }

    public static byte[] asUnsignedNByteArray(BigInteger x, int length) {
        if (x == null) {
            return null;
        }
        byte[] tmp = new byte[length];
        byte[] arrays = x.toByteArray();
        int len = arrays.length;
        if (len > length + 1) {
            return null;
        }
        if (len == length + 1) {
            if (arrays[0] != 0) {
                return null;
            }
            System.arraycopy(arrays, 1, tmp, 0, length);
            return tmp;
        }
        System.arraycopy(arrays, 0, tmp, length - len, len);
        return tmp;
    }

    public byte[] getPubXByBytes() {
        return (byte[])this.bPubX.clone();
    }

    public byte[] getPubYByBytes() {
        return (byte[])this.bPubY.clone();
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public byte[] getEncoded() {
        return null;
    }

    public String getFormat() {
        return null;
    }

    public ECPoint getQ() {
        return this.Q;
    }

    public final byte[] getDefaultZ() {
        return (byte[])this.zvalue.clone();
    }

    public BigInteger getPubX_Int() {
        return this.iPubX;
    }

    public BigInteger getPubY_Int() {
        return this.iPubY;
    }

    public final byte[] calcZ(byte[] userId) {
        return SM2Params.calcZ(this.bPubX, this.bPubY, userId);
    }
}

