/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gm;

import com.fshows.util.fnefpay.gm.SM2_Result;
import com.fshows.util.fnefpay.gm.SM3Digest;
import java.math.BigInteger;
import java.security.SecureRandom;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.crypto.util.Pack;
import shaded.org.bouncycastle.math.ec.ECCurve;
import shaded.org.bouncycastle.math.ec.ECFieldElement;
import shaded.org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    static final byte[] defaultUserId = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    public final BigInteger ecc_p;
    public final BigInteger ecc_a;
    public final BigInteger ecc_b;
    public final BigInteger ecc_n;
    public final BigInteger ecc_xG;
    public final BigInteger ecc_yG;
    public final ECCurve ecc_curve;
    public final ECPoint ecc_point_g;
    public final ECDomainParameters ecc_bc_spec;
    public final ECKeyPairGenerator ecc_key_pair_generator;
    private int _byteLen;

    public String getName() {
        return "SM2_Fq";
    }

    public int getFieldSize() {
        return this.ecc_curve.getFieldSize();
    }

    public int getPointByteLength() {
        return this._byteLen;
    }

    public SM2() {
        BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        BigInteger xG = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        BigInteger yG = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        this.ecc_p = p;
        this.ecc_a = a;
        this.ecc_b = b;
        this.ecc_n = n;
        this.ecc_xG = xG;
        this.ecc_yG = yG;
        ECFieldElement.Fp ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_xG);
        ECFieldElement.Fp ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_yG);
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, (ECFieldElement)ecc_gx_fieldelement, (ECFieldElement)ecc_gy_fieldelement);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
        this._byteLen = (int)Math.ceil((double)this.ecc_curve.getFieldSize() / 8.0);
    }

    public SM2(BigInteger p, BigInteger a, BigInteger b, BigInteger n, BigInteger xG, BigInteger yG) {
        this.ecc_p = p;
        this.ecc_a = a;
        this.ecc_b = b;
        this.ecc_n = n;
        this.ecc_xG = xG;
        this.ecc_yG = yG;
        ECFieldElement.Fp ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_xG);
        ECFieldElement.Fp ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_yG);
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, (ECFieldElement)ecc_gx_fieldelement, (ECFieldElement)ecc_gy_fieldelement);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
        this._byteLen = (int)Math.ceil((double)this.ecc_curve.getFieldSize() / 8.0);
    }

    public SM2(BigInteger p, BigInteger a, BigInteger b, BigInteger n, BigInteger xG, BigInteger yG, BigInteger h) {
        this.ecc_p = p;
        this.ecc_a = a;
        this.ecc_b = b;
        this.ecc_n = n;
        this.ecc_xG = xG;
        this.ecc_yG = yG;
        ECFieldElement.Fp ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_xG);
        ECFieldElement.Fp ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_yG);
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, (ECFieldElement)ecc_gx_fieldelement, (ECFieldElement)ecc_gy_fieldelement);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n, h);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
        this._byteLen = (int)Math.ceil((double)this.ecc_curve.getFieldSize() / 8.0);
    }

    public static byte[] BigIntegerToByteArray(BigInteger bi, int length) {
        byte[] ubibyte;
        byte[] bibyte = bi.toByteArray();
        if (bibyte[0] == 0 && bibyte.length > length) {
            ubibyte = new byte[bibyte.length - 1];
            System.arraycopy(bibyte, 1, ubibyte, 0, ubibyte.length);
        } else {
            ubibyte = bibyte;
        }
        if (ubibyte.length >= length) {
            return ubibyte;
        }
        byte[] temp = new byte[length];
        System.arraycopy(bibyte, 0, temp, length - bibyte.length, bibyte.length);
        return temp;
    }

    public byte[] BigIntegerToByteArray(BigInteger bi) {
        byte[] ubibyte;
        byte[] bibyte = bi.toByteArray();
        if (bibyte[0] == 0 && bibyte.length > this._byteLen) {
            ubibyte = new byte[bibyte.length - 1];
            System.arraycopy(bibyte, 1, ubibyte, 0, ubibyte.length);
        } else {
            ubibyte = bibyte;
        }
        if (ubibyte.length >= this._byteLen) {
            return ubibyte;
        }
        byte[] temp = new byte[this._byteLen];
        System.arraycopy(bibyte, 0, temp, this._byteLen - bibyte.length, bibyte.length);
        return temp;
    }

    public ECPoint GetPoint(BigInteger x, BigInteger y) {
        ECFieldElement.Fp ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, x);
        ECFieldElement.Fp ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, y);
        return new ECPoint.Fp(this.ecc_curve, (ECFieldElement)ecc_gx_fieldelement, (ECFieldElement)ecc_gy_fieldelement);
    }

    public ECPoint GetPublicKey(BigInteger d) {
        return this.ecc_point_g.multiply(d);
    }

    private byte[] GetENTLA(byte[] ID_A) {
        int t = ID_A.length * 8;
        byte[] ENTL_A_t = Pack.intToBigEndian((int)t);
        byte[] ENTL_A = new byte[2];
        System.arraycopy(ENTL_A_t, 2, ENTL_A, 0, 2);
        return ENTL_A;
    }

    public byte[] GetZA(byte[] userId, ECPoint publicKey) {
        SM3Digest sm3 = new SM3Digest();
        byte[] p = null;
        if (userId == null) {
            userId = defaultUserId;
        }
        p = this.GetENTLA(userId);
        sm3.update(p, 0, p.length);
        sm3.update(userId, 0, userId.length);
        p = this.BigIntegerToByteArray(this.ecc_a);
        sm3.update(p, 0, p.length);
        p = this.BigIntegerToByteArray(this.ecc_b);
        sm3.update(p, 0, p.length);
        p = this.BigIntegerToByteArray(this.ecc_xG);
        sm3.update(p, 0, p.length);
        p = this.BigIntegerToByteArray(this.ecc_yG);
        sm3.update(p, 0, p.length);
        p = this.BigIntegerToByteArray(publicKey.getX().toBigInteger());
        sm3.update(p, 0, p.length);
        p = this.BigIntegerToByteArray(publicKey.getY().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] M = new byte[sm3.getDigestSize()];
        sm3.doFinal(M, 0);
        return M;
    }

    public SM2_Result Sign(byte[] userId, byte[] M, BigInteger privateKey, BigInteger k) {
        SM2_Result sm2Ret = new SM2_Result();
        byte[] ZA = this.GetZA(userId, this.GetPublicKey(privateKey));
        byte[] m_Line = new byte[ZA.length + M.length];
        System.arraycopy(ZA, 0, m_Line, 0, ZA.length);
        System.arraycopy(M, 0, m_Line, ZA.length, M.length);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(m_Line, 0, m_Line.length);
        byte[] ebyte = new byte[sm3.getDigestSize()];
        sm3.doFinal(ebyte, 0);
        BigInteger e = new BigInteger(1, ebyte);
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            if (k == null || BigInteger.ZERO.equals(k)) {
                AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
                ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
                ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
                k = ecpriv.getD();
                kp = ecpub.getQ();
            } else {
                kp = this.ecc_point_g.multiply(k);
            }
            r = e.add(kp.getX().toBigInteger());
            if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = privateKey.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(privateKey);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Ret.r = r;
        sm2Ret.s = s;
        return sm2Ret;
    }

    public Boolean Verify(byte[] M_sq, byte[] userId, ECPoint publicKey, BigInteger r_sq, BigInteger s_sq) {
        ECPoint p00_sq;
        if (r_sq.compareTo(BigInteger.ONE) < 0 || r_sq.compareTo(this.ecc_n) > 0) {
            return false;
        }
        if (s_sq.compareTo(BigInteger.ONE) < 0 || s_sq.compareTo(this.ecc_n) > 0) {
            return false;
        }
        byte[] ZA = this.GetZA(userId, publicKey);
        byte[] m_Line_sq = new byte[ZA.length + M_sq.length];
        System.arraycopy(ZA, 0, m_Line_sq, 0, ZA.length);
        System.arraycopy(M_sq, 0, m_Line_sq, ZA.length, M_sq.length);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(m_Line_sq, 0, m_Line_sq.length);
        byte[] ebyte = new byte[sm3.getDigestSize()];
        sm3.doFinal(ebyte, 0);
        BigInteger e_sq = new BigInteger(1, ebyte);
        BigInteger t = r_sq.add(s_sq).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p0_sq = this.ecc_point_g.multiply(s_sq);
        ECPoint p1_sq = p0_sq.add(p00_sq = publicKey.multiply(t));
        BigInteger R = e_sq.add(p1_sq.getX().toBigInteger()).mod(this.ecc_n);
        return r_sq.compareTo(R) == 0;
    }

    public byte[] KDF(byte[] Z, int klen) {
        SM3Digest sm3_base = new SM3Digest();
        sm3_base.update(Z, 0, Z.length);
        int ct = 1;
        int v = sm3_base.getDigestSize() * 8;
        int klenv = (int)Math.ceil((double)klen / (double)v);
        byte[] K = new byte[klen / 8];
        int key_off = 0;
        for (int i = 1; i <= klenv - 1; ++i) {
            SM3Digest sm3_ha = new SM3Digest(sm3_base);
            sm3_ha.update((byte)(ct >> 24 & 0xFF));
            sm3_ha.update((byte)(ct >> 16 & 0xFF));
            sm3_ha.update((byte)(ct >> 8 & 0xFF));
            sm3_ha.update((byte)(ct & 0xFF));
            sm3_ha.doFinal(K, key_off);
            key_off += sm3_ha.getDigestSize();
            ++ct;
        }
        SM3Digest sm3_ha_end = new SM3Digest(sm3_base);
        sm3_ha_end.update((byte)(ct >> 24 & 0xFF));
        sm3_ha_end.update((byte)(ct >> 16 & 0xFF));
        sm3_ha_end.update((byte)(ct >> 8 & 0xFF));
        sm3_ha_end.update((byte)(ct & 0xFF));
        int remainder = klen % v / 8;
        if (remainder == 0) {
            sm3_ha_end.doFinal(K, key_off);
        } else {
            byte[] tmp = new byte[sm3_ha_end.getDigestSize()];
            sm3_ha_end.doFinal(tmp, 0);
            System.arraycopy(tmp, 0, K, key_off, remainder);
        }
        return K;
    }

    public byte[] CombineByteArray(byte[] ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        int len = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            len += args[i].length;
        }
        byte[] ret = new byte[len];
        int pos = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].length == 0) continue;
            System.arraycopy(args[i], 0, ret, pos, args[i].length);
            pos += args[i].length;
        }
        return ret;
    }
}

