/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gm;

import com.fshows.util.fnefpay.gm.X509Cert_SM2;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Sequence;
import shaded.org.bouncycastle.crypto.BlockCipher;
import shaded.org.bouncycastle.crypto.CipherParameters;
import shaded.org.bouncycastle.crypto.DataLengthException;
import shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import shaded.org.bouncycastle.crypto.digests.SM3Digest;
import shaded.org.bouncycastle.crypto.engines.SM4Engine;
import shaded.org.bouncycastle.crypto.modes.CBCBlockCipher;
import shaded.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import shaded.org.bouncycastle.crypto.paddings.PKCS7Padding;
import shaded.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import shaded.org.bouncycastle.crypto.params.KeyParameter;
import shaded.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.org.bouncycastle.util.encoders.Base64;
import shaded.org.bouncycastle.util.encoders.Hex;

public class PKCS12_SM2 {
    private ASN1Sequence privateInfo = null;
    private ASN1Sequence publicInfo = null;
    private String SM2PrivateKey;
    private X509Cert_SM2 cert;

    public static PKCS12_SM2 getInstance(Object obj) throws Exception {
        if (obj instanceof PKCS12_SM2) {
            return (PKCS12_SM2)obj;
        }
        if (obj instanceof byte[]) {
            return new PKCS12_SM2((byte[])obj);
        }
        if (obj != null) {
            return new PKCS12_SM2(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public PKCS12_SM2() {
    }

    public PKCS12_SM2(byte[] encoding) throws Exception {
        if (encoding == null) {
            throw new Exception("SM2File encoding should not be null");
        }
        this.load(encoding);
    }

    public PKCS12_SM2(ASN1Sequence seq) throws Exception {
        this.parseSM2(seq);
    }

    public PKCS12_SM2(ASN1Sequence publicInfo, ASN1Sequence privateInfo) throws Exception {
        if (publicInfo == null) {
            throw new Exception("SM2File publicInfo should not be null");
        }
        if (privateInfo == null) {
            throw new Exception("SM2File privateInfo should not be null");
        }
        this.parseSM2Certs(privateInfo, publicInfo);
    }

    public void load(byte[] data) throws Exception {
        ASN1Sequence seq;
        try {
            data = Base64.decode((byte[])data);
            seq = ASN1Sequence.getInstance((Object)data);
        }
        catch (Exception e) {
            throw new Exception("SM2File Decoding failure", e);
        }
        this.parseSM2(seq);
    }

    public void parseSM2(ASN1Sequence seq) throws Exception {
        if (seq == null || seq.size() != 3) {
            throw new Exception("invalid SM2File encoding");
        }
        this.parseSM2Certs((ASN1Sequence)seq.getObjectAt(1), (ASN1Sequence)seq.getObjectAt(2));
    }

    private void parseSM2Certs(ASN1Sequence privateInfo, ASN1Sequence publicInfo) throws Exception {
        if (privateInfo.size() != 3) {
            throw new Exception("the sm2 file is not right format,can not get the private part");
        }
        if (publicInfo.size() != 2) {
            throw new Exception("the sm2 file is not right format.can not get the public part");
        }
        this.privateInfo = privateInfo;
        this.publicInfo = publicInfo;
        ASN1OctetString pubOctString = (ASN1OctetString)publicInfo.getObjectAt(1);
        this.cert = new X509Cert_SM2(pubOctString.getOctets());
        String pubKeystr = Hex.toHexString((byte[])this.cert.getPublicKey());
        String publicKeyXHex = pubKeystr.substring(0, pubKeystr.length() / 2);
        String publicKeyYHex = pubKeystr.substring(pubKeystr.length() / 2);
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    public String getPrivateKey() throws Exception {
        if (this.SM2PrivateKey == null) {
            return null;
        }
        return this.SM2PrivateKey;
    }

    public BigInteger getPrivateKey(String password) throws Exception {
        return this.decrypt(password);
    }

    public BigInteger decrypt(String password) throws Exception {
        byte[] encryptedData;
        if (password == null) {
            throw new Exception("SM2File password should not be null");
        }
        if (this.privateInfo == null) {
            throw new Exception("SM2File invalid : privateInfo=null");
        }
        ASN1OctetString priOctString = (ASN1OctetString)this.privateInfo.getObjectAt(2);
        try {
            encryptedData = priOctString.getOctets();
        }
        catch (Exception e) {
            throw new Exception("SM2File decoding failure", e);
        }
        String dBytes = PKCS12_SM2.SM4DecryptDBytes(password, encryptedData);
        return new BigInteger(dBytes, 16);
    }

    public static final String SM4DecryptDBytes(String password, byte[] encryptedData) throws Exception {
        byte[] sm4;
        byte[] iv;
        byte[] passwordBytes;
        if (password == null || password.length() == 0) {
            throw new Exception("SM2File password should not be null");
        }
        try {
            passwordBytes = password.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("SM2File password decoding failure", e);
        }
        if (encryptedData == null || encryptedData.length == 0) {
            throw new Exception("SM2File encryptedData should not be null");
        }
        if (encryptedData.length < 32 || encryptedData.length > 64) {
            throw new Exception("SM2File EncryptedData required length in [32-64] ");
        }
        byte[] encoding = null;
        if (encryptedData.length == 32 || encryptedData.length == 48) {
            encoding = encryptedData;
        } else {
            try {
                encoding = Base64.decode((byte[])encryptedData);
            }
            catch (Exception e) {
                throw new Exception("SM2File EncryptedData required base64 ");
            }
        }
        try {
            byte[] hash = PKCS12_SM2.KDF(passwordBytes);
            iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            sm4 = new byte[16];
            System.arraycopy(hash, 16, sm4, 0, 16);
        }
        catch (Exception e) {
            throw new Exception("SM2File KDF failure", e);
        }
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new SM4Engine()), (BlockCipherPadding)new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(sm4), iv);
            cipher.init(false, (CipherParameters)params);
            int outLength = cipher.getOutputSize(encoding.length);
            byte[] out = new byte[outLength];
            int dataLength = cipher.processBytes(encoding, 0, encoding.length, out, 0);
            int lastLength = cipher.doFinal(out, dataLength);
            int realLength = dataLength + lastLength;
            byte[] dBytes = null;
            if (realLength < outLength) {
                dBytes = new byte[realLength];
                System.arraycopy(out, 0, dBytes, 0, realLength);
            } else {
                dBytes = out;
            }
            return Hex.toHexString((byte[])dBytes);
        }
        catch (DataLengthException e) {
            throw new Exception("SM2File SM2PrivateKey decrypt failure with IllegalDataLength", e);
        }
        catch (IllegalArgumentException e) {
            throw new Exception("SM2File SM2PrivateKey decrypt failure with IllegalArgument", e);
        }
        catch (IllegalStateException e) {
            throw new Exception("SM2File SM2PrivateKey decrypt failure with IllegalState", e);
        }
        catch (InvalidCipherTextException e) {
            throw new Exception("SM2File SM2PrivateKey decrypt failure with InvalidCipherText", e);
        }
        catch (Exception e) {
            throw new Exception("SM2File SM2PrivateKey decrypt failure", e);
        }
    }

    public X509Cert_SM2 getPublicCert() throws Exception {
        if (this.cert == null) {
            throw new Exception("SM2File invalid : cert=null");
        }
        return this.cert;
    }
}

