/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gm;

import com.fshows.util.fnefpay.gm.PKCS12_SM2;
import com.fshows.util.fnefpay.gm.X509Cert_SM2;
import com.fshows.util.fnefpay.sdk.FnefPayConfig;
import com.fshows.util.fnefpay.util.CerFilter;
import com.fshows.util.fnefpay.util.FileUtils;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class CertUtils_SM2 {
    private static BigInteger priKey = null;
    private static String signCertId = null;
    private static List<String> certFiles = new ArrayList<String>();
    private static Map<String, X509Cert_SM2> certMap = new HashMap<String, X509Cert_SM2>();
    private static final Map<String, Map<String, Object>> priKeyMap = new ConcurrentHashMap<String, Map<String, Object>>();

    private static void init() throws Exception {
        CertUtils_SM2.initSignCert();
        CertUtils_SM2.initVerifyCert();
    }

    private static void initSignCert() throws Exception {
        String certPath = FnefPayConfig.getConfig().getGmSignCertPath();
        if (StringUtils.isBlank((CharSequence)certPath)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a");
        }
        String certPwd = FnefPayConfig.getConfig().getGmSignCertPwd();
        if (StringUtils.isBlank((CharSequence)certPwd)) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u5bc6\u7801\u4e3a\u7a7a");
        }
        if (priKey != null) {
            priKey = null;
        }
        byte[] arrayOfByte = FileUtils.getSM2File(certPath);
        PKCS12_SM2 P12 = new PKCS12_SM2(arrayOfByte);
        priKey = P12.getPrivateKey(certPwd);
        X509Cert_SM2 cert = P12.getPublicCert();
        signCertId = cert.getCertId();
    }

    private static void initVerifyCert() throws Exception {
        String certDir = FnefPayConfig.getConfig().getGmVerifyCertDir();
        if (StringUtils.isBlank((CharSequence)certDir)) {
            throw new IllegalArgumentException("\u516c\u94a5\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a");
        }
        CertUtils_SM2.readCertFile(certDir);
        for (int i = 0; i < certFiles.size(); ++i) {
            X509Cert_SM2 certSm2 = new X509Cert_SM2(certFiles.get(i));
            certMap.put(certSm2.getCertId(), certSm2);
        }
    }

    public static void readCertFile(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            for (File f : file.listFiles(new CerFilter())) {
                CertUtils_SM2.readCertFile(f.getAbsolutePath());
            }
        } else if (file.exists()) {
            certFiles.add(file.getAbsolutePath());
        }
    }

    private static void loadSignCert(String certFilePath, String certPwd) throws Exception {
        HashMap<String, Object> priMap = new HashMap<String, Object>();
        byte[] arrayOfByte = FileUtils.getSM2File(FnefPayConfig.getConfig().getGmSignCertPath());
        PKCS12_SM2 P12 = new PKCS12_SM2(arrayOfByte);
        X509Cert_SM2 cert = P12.getPublicCert();
        priMap.put("priKey", P12.getPrivateKey(FnefPayConfig.getConfig().getGmSignCertPwd()));
        priMap.put("signCertId", cert.getCertId());
        priKeyMap.put(certFilePath, priMap);
    }

    public static Map<String, Object> getSignCertByStoreMap(String certPath, String certPwd) throws Exception {
        if (!priKeyMap.containsKey(certPath)) {
            CertUtils_SM2.loadSignCert(certPath, certPwd);
        }
        return priKeyMap.get(certPath);
    }

    public static BigInteger getPrivateKey() {
        return priKey;
    }

    public static String getSignCertId() {
        return signCertId;
    }

    public static byte[] getPublicKey(String certId) {
        return CertUtils_SM2.getVryCert(certId).getPublicKey();
    }

    public static X509Cert_SM2 getVryCert(String certId) {
        return certMap.get(certId);
    }

    static {
        try {
            CertUtils_SM2.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

