/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gj;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class SecureUtils_RSA {
    private static final String ALGORITHM_SHA256 = "SHA-256";
    private static final String BC_PROV_ALGORITHM_SHA1RSA = "SHA1withRSA";

    private static byte[] sha256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = null;
        md = MessageDigest.getInstance(ALGORITHM_SHA256);
        md.reset();
        md.update(data);
        return md.digest();
    }

    public static byte[] sha256(String datas, String encoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return SecureUtils_RSA.sha256(datas.getBytes(encoding));
    }

    public static byte[] signBySoft(PrivateKey privateKey, byte[] data) throws Exception {
        Signature st = Signature.getInstance(BC_PROV_ALGORITHM_SHA1RSA, "BC");
        st.initSign(privateKey);
        st.update(data);
        byte[] result = st.sign();
        return result;
    }

    public static boolean validateSignBySoft(PublicKey publicKey, byte[] signData, byte[] srcData) throws Exception {
        Signature st = Signature.getInstance(BC_PROV_ALGORITHM_SHA1RSA, "BC");
        st.initVerify(publicKey);
        st.update(srcData);
        return st.verify(signData);
    }

    private static byte[] pin2PinBlock(String aPin) {
        int tTemp = 1;
        int tPinLen = aPin.length();
        byte[] tByte = new byte[8];
        try {
            tByte[0] = (byte)Integer.parseInt(Integer.toString(tPinLen), 10);
            if (tPinLen % 2 == 0) {
                for (int i = 0; i < tPinLen; i += 2) {
                    String a = aPin.substring(i, i + 2);
                    tByte[tTemp] = (byte)Integer.parseInt(a, 16);
                    if (i == tPinLen - 2 && tTemp < 7) {
                        for (int x = tTemp + 1; x < 8; ++x) {
                            tByte[x] = -1;
                        }
                    }
                    ++tTemp;
                }
            } else {
                for (int i = 0; i < tPinLen - 1; i += 2) {
                    String a = aPin.substring(i, i + 2);
                    tByte[tTemp] = (byte)Integer.parseInt(a, 16);
                    if (i == tPinLen - 3) {
                        String b = aPin.substring(tPinLen - 1) + "F";
                        tByte[tTemp + 1] = (byte)Integer.parseInt(b, 16);
                        if (tTemp + 1 < 7) {
                            for (int x = tTemp + 2; x < 8; ++x) {
                                tByte[x] = -1;
                            }
                        }
                    }
                    ++tTemp;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tByte;
    }

    private static byte[] formatPan(String aPan) {
        int tPanLen = aPan.length();
        byte[] tByte = new byte[8];
        int temp = tPanLen - 13;
        try {
            tByte[0] = 0;
            tByte[1] = 0;
            for (int i = 2; i < 8; ++i) {
                String a = aPan.substring(temp, temp + 2);
                tByte[i] = (byte)Integer.parseInt(a, 16);
                temp += 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tByte;
    }

    public static byte[] pin2PinBlockWithCardNO(String aPin, String aCardNO) {
        byte[] tPinByte = SecureUtils_RSA.pin2PinBlock(aPin);
        if (aCardNO.length() == 11) {
            aCardNO = "00" + aCardNO;
        } else if (aCardNO.length() == 12) {
            aCardNO = "0" + aCardNO;
        }
        byte[] tPanByte = SecureUtils_RSA.formatPan(aCardNO);
        byte[] tByte = new byte[8];
        for (int i = 0; i < 8; ++i) {
            tByte[i] = (byte)(tPinByte[i] ^ tPanByte[i]);
        }
        return tByte;
    }
}

