/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gj;

import com.fshows.util.fnefpay.gj.DesUtils;
import java.security.GeneralSecurityException;

public class MACUtils {
    public static byte[] calculateANSIX9_9MAC(byte[] key, byte[] data) throws GeneralSecurityException {
        int dataLength = data.length;
        int lastLength = dataLength % 8;
        int lastBlockLength = lastLength == 0 ? 8 : lastLength;
        int blockCount = dataLength / 8 + (lastLength > 0 ? 1 : 0);
        byte[][] dataBlock = new byte[blockCount][8];
        for (int i = 0; i < blockCount; ++i) {
            int copyLength = i == blockCount - 1 ? lastBlockLength : 8;
            System.arraycopy(data, i * 8, dataBlock[i], 0, copyLength);
        }
        byte[] desXor = new byte[8];
        for (int i = 0; i < blockCount; ++i) {
            byte[] tXor = DesUtils.xOr(desXor, dataBlock[i]);
            desXor = DesUtils.encryptByDesEcb(tXor, key);
        }
        return desXor;
    }

    public static byte[] calculateANSIX9_19MAC(byte[] key, byte[] data) throws GeneralSecurityException {
        if (key == null || data == null) {
            return null;
        }
        if (key.length != 16) {
            throw new RuntimeException("\u79d8\u94a5\u957f\u5ea6\u9519\u8bef.");
        }
        byte[] keyLeft = new byte[8];
        byte[] keyRight = new byte[8];
        System.arraycopy(key, 0, keyLeft, 0, 8);
        System.arraycopy(key, 8, keyRight, 0, 8);
        byte[] result99 = MACUtils.calculateANSIX9_9MAC(keyLeft, data);
        byte[] resultTemp = DesUtils.decryptByDesEcb(result99, keyRight);
        return DesUtils.encryptByDesEcb(resultTemp, keyLeft);
    }

    public static byte[] calculatePboc3desMAC(byte[] data, byte[] key, byte[] icv) throws Exception {
        if (key == null || data == null) {
            throw new RuntimeException("data or key is null.");
        }
        if (key.length != 16) {
            throw new RuntimeException("key length is not 16 byte.");
        }
        byte[] leftKey = new byte[8];
        System.arraycopy(key, 0, leftKey, 0, 8);
        int dataLength = data.length;
        int blockCount = dataLength / 8 + 1;
        int lastBlockLength = dataLength % 8;
        byte[][] dataBlock = new byte[blockCount][8];
        for (int i = 0; i < blockCount; ++i) {
            int copyLength = i == blockCount - 1 ? lastBlockLength : 8;
            System.arraycopy(data, i * 8, dataBlock[i], 0, copyLength);
        }
        dataBlock[blockCount - 1][lastBlockLength] = -128;
        byte[] desXor = DesUtils.xOr(dataBlock[0], icv);
        for (int i = 1; i < blockCount; ++i) {
            byte[] des = DesUtils.encryptByDesCbc(desXor, leftKey);
            desXor = DesUtils.xOr(dataBlock[i], des);
        }
        desXor = DesUtils.encryptBy3DesCbc(desXor, key);
        return desXor;
    }
}

