/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gj;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DesUtils {
    public static final byte[] ZERO_IVC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public static byte[] create3DESKey() throws GeneralSecurityException {
        KeyGenerator kg = KeyGenerator.getInstance("DESede");
        kg.init(112);
        byte[] key24 = kg.generateKey().getEncoded();
        byte[] result = new byte[16];
        System.arraycopy(key24, 0, result, 0, 16);
        return result;
    }

    public static byte[] encryptBy3DesCbc(byte[] content, byte[] key, byte[] ivb) throws GeneralSecurityException {
        byte[] _3deskey = new byte[24];
        System.arraycopy(key, 0, _3deskey, 0, 16);
        System.arraycopy(key, 0, _3deskey, 16, 8);
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        SecretKeySpec secureKey = new SecretKeySpec(_3deskey, "DESede");
        IvParameterSpec iv = new IvParameterSpec(ivb);
        cipher.init(1, (Key)secureKey, iv);
        return cipher.doFinal(content);
    }

    public static byte[] decryptBy3DesCbc(byte[] content, byte[] key, byte[] ivb) throws GeneralSecurityException {
        byte[] _3deskey = new byte[24];
        System.arraycopy(key, 0, _3deskey, 0, 16);
        System.arraycopy(key, 0, _3deskey, 16, 8);
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        SecretKeySpec secureKey = new SecretKeySpec(_3deskey, "DESede");
        IvParameterSpec iv = new IvParameterSpec(ivb);
        cipher.init(2, (Key)secureKey, iv);
        return cipher.doFinal(content);
    }

    public static byte[] encryptBy3DesCbc(byte[] content, byte[] key) throws GeneralSecurityException {
        return DesUtils.encryptBy3DesCbc(content, key, ZERO_IVC);
    }

    public static byte[] decryptBy3DesCbc(byte[] content, byte[] key) throws GeneralSecurityException {
        return DesUtils.decryptBy3DesCbc(content, key, ZERO_IVC);
    }

    public static byte[] encryptBy3DesEcb(byte[] content, byte[] key) throws GeneralSecurityException {
        byte[] _3deskey = new byte[24];
        System.arraycopy(key, 0, _3deskey, 0, 16);
        System.arraycopy(key, 0, _3deskey, 16, 8);
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        SecretKeySpec secureKey = new SecretKeySpec(_3deskey, "DESede");
        cipher.init(1, secureKey);
        return cipher.doFinal(content);
    }

    public static byte[] decryptBy3DesEcb(byte[] content, byte[] key) throws GeneralSecurityException {
        byte[] _3deskey = new byte[24];
        System.arraycopy(key, 0, _3deskey, 0, 16);
        System.arraycopy(key, 0, _3deskey, 16, 8);
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        SecretKeySpec secureKey = new SecretKeySpec(_3deskey, "DESede");
        cipher.init(2, secureKey);
        return cipher.doFinal(content);
    }

    public static byte[] encryptByDesCbc(byte[] content, byte[] key) throws GeneralSecurityException {
        return DesUtils.encryptByDesCbc(content, key, ZERO_IVC);
    }

    public static byte[] decryptByDesCbc(byte[] content, byte[] key) throws GeneralSecurityException {
        return DesUtils.decryptByDesCbc(content, key, ZERO_IVC);
    }

    public static byte[] encryptByDesCbc(byte[] content, byte[] key, byte[] icv) throws GeneralSecurityException {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
        IvParameterSpec iv = new IvParameterSpec(icv);
        cipher.init(1, (Key)secretKey, iv, sr);
        return cipher.doFinal(content);
    }

    public static byte[] decryptByDesCbc(byte[] content, byte[] key, byte[] icv) throws GeneralSecurityException {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
        IvParameterSpec iv = new IvParameterSpec(icv);
        cipher.init(2, (Key)secretKey, iv, sr);
        return cipher.doFinal(content);
    }

    public static byte[] encryptByDesEcb(byte[] content, byte[] key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(new DESKeySpec(key));
        cipher.init(1, secretKey);
        return cipher.doFinal(content);
    }

    public static byte[] decryptByDesEcb(byte[] content, byte[] key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(new DESKeySpec(key));
        cipher.init(2, secretKey);
        return cipher.doFinal(content);
    }

    public static byte[] encryptBy3DesCbcLast8Mac(byte[] content, byte[] key) throws GeneralSecurityException {
        byte[] edata = DesUtils.encryptBy3DesCbc(content, key);
        byte[] result = new byte[8];
        System.arraycopy(edata, edata.length - 8, result, 0, 8);
        return result;
    }

    public static byte[] xOr(byte[] b1, byte[] b2) {
        byte[] tXor = new byte[Math.min(b1.length, b2.length)];
        for (int i = 0; i < tXor.length; ++i) {
            tXor[i] = (byte)(b1[i] ^ b2[i]);
        }
        return tXor;
    }

    public static void int2byte(int n, byte[] buf, int offset) {
        buf[offset] = (byte)(n >> 24);
        buf[offset + 1] = (byte)(n >> 16);
        buf[offset + 2] = (byte)(n >> 8);
        buf[offset + 3] = (byte)n;
    }

    public static void long2byte(long n, byte[] buf, int offset) {
        buf[offset] = (byte)(n >> 56);
        buf[offset + 1] = (byte)(n >> 48);
        buf[offset + 2] = (byte)(n >> 40);
        buf[offset + 3] = (byte)(n >> 32);
        buf[offset + 4] = (byte)(n >> 24);
        buf[offset + 5] = (byte)(n >> 16);
        buf[offset + 6] = (byte)(n >> 8);
        buf[offset + 7] = (byte)n;
    }
}

