package com.fshows.util.fnefpay.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * 属性工具类
 */
public class PropertyUtils {
    // term.properties预先存放TMK密钥
    static String profilepath = "term.properties";

    private Properties props;

    /**
     * 构造函数
     */
    public PropertyUtils() {
        FileInputStream inputFile = null;
        props = new Properties();
        try {
            inputFile = new FileInputStream(profilepath);
            props.load(inputFile);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (null != inputFile) {
                try {
                    inputFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 构造函数
     *
     * @param filePath 文件路径
     */
    public PropertyUtils(String filePath) {
        FileInputStream inputFile = null;
        props = new Properties();
        try {
            inputFile = new FileInputStream(filePath);
            props.load(inputFile);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (null != inputFile) {
                try {
                    inputFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 读取属性文件中相应键的值
     *
     * @param key 键
     * @return String  值
     */
    public String getKeyValue(String key) {
        return props.getProperty(key);
    }

    /**
     * 设置属性值
     *
     * @param key   键
     * @param value 值
     */
    public void setKeyValue(String key, String value) {
        props.setProperty(key, value);
    }

    /**
     * 保存属性内容
     *
     * @description 属性内容
     */
    public void saveFile(String description) {
        FileOutputStream outputFile = null;
        try {
            outputFile = new FileOutputStream(profilepath);
            props.store(outputFile, description);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            if (null != outputFile) {
                try {
                    outputFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 保存属性内容
     *
     * @param filePath    属性文件路径
     * @param description 属性内容
     */
    public void saveFile(String filePath, String description) {
        FileOutputStream outputFile = null;
        try {
            outputFile = new FileOutputStream(filePath);
            props.store(outputFile, description);
            outputFile.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            if (null != outputFile) {
                try {
                    outputFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
