package com.fshows.util.fnefpay.util;

import com.fshows.util.fnefpay.exception.TransException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtlis {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtlis.class);

    /**
     * 发送HTTP请求
     * @param messege  报文内容
     * @param url   新收银台地址
     * @param actionPath 接口全路径
     * @params timeOut  连接超时时间
     * @param readTimeOut 响应超时时间
     */
    public static String sendHttpRequest(String messege,String url,String actionPath,String timeOut,String readTimeOut) throws TransException {
        try {
            HttpClient client = new HttpClient(url+actionPath , Integer.valueOf(timeOut), Integer.valueOf(readTimeOut));
            int code = client.send(messege, "UTF-8");
            String response = client.getResult();
            if (code != 200) {
                logger.error("Error:{}", response);
                throw new TransException(response);
            } else {
                return response;
            }
        } catch (Exception var7) {
            logger.error("请求异常！", var7);
            throw new TransException("请求异常！" + var7.getMessage());
        }
    }
}
