package com.fshows.util.fnefpay.util;

import java.io.FileInputStream;

/**
 * 文件处理工具类
 */
public class FileUtils {
    /**
     * 读取SM2文件
     *
     * @param filePath 文件路径
     * @return 文件内容
     */
    public static byte[] getSM2File(String filePath) throws Exception {
        FileInputStream crls = null;
        try {
            crls = new FileInputStream(filePath);
            byte[] out = new byte[crls.available()];
            byte[] buffer = new byte[65536];
            int offset = 0;
            int rLength;
            while ((rLength = crls.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
            byte[] arrayOfByte1 = out;
            return arrayOfByte1;
        } finally {
            if (crls != null) {
                crls.close();
            }
        }
    }
}
