package com.fshows.util.fnefpay.sdk;

import com.fshows.util.fnefpay.gj.CertUtils_RSA;
import com.fshows.util.fnefpay.gj.MACUtils;
import com.fshows.util.fnefpay.gj.SecureUtils_RSA;
import com.fshows.util.fnefpay.gm.CertUtils_SM2;
import com.fshows.util.fnefpay.gm.SecureUtils_SM2;
import com.fshows.util.fnefpay.util.Base64Utils;
import com.fshows.util.fnefpay.util.ByteUtils;
import com.fshows.util.fnefpay.util.PropertyUtils;
import shaded.org.bouncycastle.util.encoders.Hex;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.fshows.util.fnefpay.sdk.FnefPayConstants.*;

/**
 * sdk通用工具类
 */
public class FnefPayUtils {


    /**
     * 验证签名
     *
     * @param reqData    请求报文
     * @param resData    响应报文
     * @param encoding   编码
     * @param signMethod 签名方式
     * @return
     * @throws Exception
     */
    public static boolean validate(Map<String, Object> reqData, Map<String, Object> resData, String encoding, String signMethod) throws Exception {
        if (isEmpty(encoding)) {
            encoding = UTF_8_ENCODING;
        }
        if (isEmpty(signMethod)) {
            signMethod = SIGNMETHOD_RSA;
        }
        String stringSign = (String) resData.get(PARAM_SIGNATURE);
        String stringData = (String) resData.get(PARAM_PLAIN);
//		LogUtils.getLogger().info("签名原文：["+stringSign+"]");
//		LogUtils.getLogger().info("待验签返回报文串：["+stringData+"]");
        if (SIGNMETHOD_RSA.equals(signMethod)) {
            // 从配置文件文中获取certId ，然后去证书静态Map中查询对应验签证书对象
            String certId = FnefPayConfig.getConfig().getValidateCertSn();
//			LogUtils.getLogger().info("对返回报文串验签使用的验签公钥序列号：["+certId+"]");
            return SecureUtils_RSA.validateSignBySoft(CertUtils_RSA.getValidatePublicKey(certId),
                    Base64Utils.base64Decode(stringSign.getBytes(encoding)), stringData.getBytes(encoding));
        }
        if (SIGNMETHOD_SM2.equals(signMethod)) {
            // 从配置文件文中获取certId ，然后去证书静态Map中查询对应验签证书对象
            String certId = FnefPayConfig.getConfig().getGmValidateCertSn();
//			LogUtils.getLogger().info("对返回报文串验签使用的验签公钥序列号：["+certId+"]");
            String hexSign = Hex.toHexString(Base64Utils.base64Decode(stringSign.getBytes(encoding)));
            return SecureUtils_SM2.validate(hexSign, stringData, encoding, certId);
        }
        if (SIGNMETHOD_MAC.equals(signMethod)) {
            // 获取终端号及终端号对应的密钥
            String termId = (String) reqData.get(PARAM_TERMINALID);
            PropertyUtils propertyUtil = new PropertyUtils();
            String macKey = propertyUtil.getKeyValue(MACKEY_TAG_LEFT + termId + MACKEY_TAG_RIGHT);
            if (isEmpty(macKey)) {
//				LogUtils.getLogger().info("获取密钥失败:"+MACKEY_TAG_LEFT+termId+MACKEY_TAG_RIGHT);
                return false;
            }
            // 对报文进行SHA256
            byte[] byteData = SecureUtils_RSA.sha256(stringData, UTF_8_ENCODING);
            byte[] byteBsData = Base64Utils.base64Encode(byteData);
            // 计算MAC
            byte[] byteMac = MACUtils.calculateANSIX9_9MAC(ByteUtils.hexStringToBytes(macKey), byteBsData);
            if (stringSign.equals(ByteUtils.getHexString(byteMac).toUpperCase())) {
                return true;
            }
        }
        return false;
    }



    /**
     * 获取报文消息体
     *
     * @param result
     * @return
     */
    public static String getMessage(String result) {
        Pattern p = Pattern.compile("<Message>(.*?)</Message>", Pattern.CASE_INSENSITIVE | Pattern.DOTALL);
        Matcher m = p.matcher(result);
        String retStr = null;
        while (m.find()) {
            retStr = m.group(1);
        }
        return retStr;
    }

    /**
     * 获取报文签名
     *
     * @param result
     * @return
     */
    public static String getSignature(String result) {
        Pattern p = Pattern.compile("<Signature>(.*?)</Signature>");
        Matcher m = p.matcher(result);
        String retStr = null;
        while (m.find()) {
            retStr = m.group(1);
        }
        return retStr;
    }

    /**
     * 过滤请求报文中的NULL值或者空值
     *
     * @param contentData 报文内容
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static Map<String, Object> filterBlank(Map<String, Object> contentData) {
        Map<String, Object> submitFromData = new HashMap<String, Object>();
        Set<String> keyset = contentData.keySet();

        for (String key : keyset) {
            Object value = contentData.get(key);
            if (value instanceof ArrayList) {
                // 列表
                if (value != null && ((ArrayList) value).size() != 0) {
                    submitFromData.put(key, value);
//					LogUtils.getLogger().info(key + "-->" + value);
                }
            } else if (value instanceof Map) {
                // 数组
                if (value != null && ((Map) value).size() != 0) {
                    submitFromData.put(key, value);
//					LogUtils.getLogger().info(key + "-->" + value);
                }
            } else {
                if (value != null && !"".equals(String.valueOf(value).trim())) {
                    // 对value值进行去除前后空处理
                    submitFromData.put(key, String.valueOf(value).trim());
//					LogUtils.getLogger().info(key + "-->" + String.valueOf(value));
                }
            }
        }

        return submitFromData;
    }

    /**
     * 打印MAP值
     *
     * @param contentData 报文内容
     * @return
     */
    @SuppressWarnings("unchecked")
    public static void printMap(Map<String, Object> contentData) {
//		LogUtils.getLogger().info("打印响应报文域 :");
        Set<String> keyset = contentData.keySet();
        for (String key : keyset) {
            Object value = contentData.get(key);
            if (value instanceof Map) {
                printMap((Map<String, Object>) value);
            } else {
                if (value != null && !"".equals(((String) value).trim())) {
//					LogUtils.getLogger().info(key + "-->" + String.valueOf(value));
                }
            }
        }
    }

    /**
     * 判断字符串是否为NULL或空
     *
     * @param s 待判断的字符串数据
     * @return 判断结果 true-是 false-否
     */
    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }

}
