package com.fshows.util.fnefpay.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @description sdk配置文件fnefpay_sdk.properties配置信息类
 * @date 2021-6-29 下午3:05:50
 */
public class FnefPayConfig {
	public static final String FILE_NAME = "fnefpay_sdk.properties";

	/** 后台请求URL */
	private String backRequestUrl;
	private String gh11BackRequestUrl;
	private String gh12BackRequestUrl;
	private String gh13BackRequestUrl;
	private String gh21BackRequestUrl;
	private String gh22BackRequestUrl;
	private String gh23BackRequestUrl;
	private String ghzscBackRequestUrl;
	private String ghyzBackRequestUrl;
	/** 连接超时时间 */
	private String connectTimeOut;
	/** 读取超时时间 */
	private String readTimeOut;
	/** 商户编号 */
	private String merchantId;
	/** 终端编号 */
	private String terminalId;
	/**是否验证https证书 */
	private Boolean ifValidateRemoteCert;
	/** 国际签名证书路径 */
	private String signCertPath;
	/** 国际签名证书密码 */
	private String signCertPwd;
	/** 国际验证签名公钥证书目录 */
	private String validateCertDir;
	/** 国际验签证书序号 */
	private String validateCertSn;
	/** 国密签名证书路径 */
	private String gmSignCertPath;
	/** 国密签名证书密码 */
	private String gmSignCertPwd;
	/** 国密验证签名公钥证书目录 */
	private String gmVerifyCertDir;
	/** 国密验签证书序号 */
	private String gmValidateCertSn;
	/** 商户标识 */
	private String merInstId;
	/** 签名方式 */
	private String signMethod;

	/** 配置文件中的后台URL常量 */
	public static final String SDK_BACK_URL = "fnefpay.backTransUrl";
	public static final String SDK_GH11_BACK_URL = "fnefpay.gh11.backTransUrl";
	public static final String SDK_GH12_BACK_URL = "fnefpay.gh12.backTransUrl";
	public static final String SDK_GH13_BACK_URL = "fnefpay.gh13.backTransUrl";
	public static final String SDK_GH21_BACK_URL = "fnefpay.gh21.backTransUrl";
	public static final String SDK_GH22_BACK_URL = "fnefpay.gh22.backTransUrl";
	public static final String SDK_GH23_BACK_URL = "fnefpay.gh23.backTransUrl";
	public static final String SDK_GHZSC_BACK_URL = "fnefpay.ghzsc.backTransUrl";
	public static final String SDK_GHYZ_BACK_URL = "fnefpay.ghyz.backTransUrl";
	/** 配置文件中的读取超时时间常量 */
	public static final String SDK_READ_TIME_OUT = "fnefpay.readTimeOut";
	/** 配置文件中的连接超时时间常量 */
	public static final String SDK_CONNECT_TIME_OUT = "fnefpay.connectTimeOut";
	/** 配置文件中的商户编号 */
	public static final String SDK_MERCHANT_ID = "fnefpay.merchantId";
	/** 配置文件中的终端编号 */
	public static final String SDK_TERMINAL_ID = "fnefpay.terminalId";
	/** 配置文件中的是否验证https证书*/
	public static final String SDK_IF_VALIDATE_REMOTE_CERT = "fnefpay.ifValidateRemoteCert";
	/** 配置文件中国际签名证书路径常量 */
	public static final String SDK_SIGNCERT_PATH = "fnefpay.signCert.path";
	/** 配置文件中国际签名证书密码常量 */
	public static final String SDK_SIGNCERT_PWD = "fnefpay.signCert.pwd";
	/** 配置文件中国际签名证书类型常量 */
	public static final String SDK_SIGNCERT_TYPE = "fnefpay.signCert.type";
	/** 配置文件中国际验证签名证书目录常量 */
	public static final String SDK_VALIDATECERT_DIR = "fnefpay.validateCert.dir";
	/** 配置文件中签名方式常量 */
	public static final String SDK_SIGN_METHOD ="fnefpay.signMethod";
	/** 配置文件中商户标识常量 */
	public static final String SDK_MERINSTID ="fnefpay.merInstId";
	/** 配置文件中国际验签证书序号*/
	public static final String SDK_VALIDATECERT_SN ="fnefpay.validateCert.sn";
	/** 配置文件中国密签名证书路径 */
	private static final String SDK_GM_SIGN_CERT_PATH = "fnefpay.gmSignCert.path";
	/** 配置文件中国密签名证书密码 */
	private static final String SDK_GM_SIGN_CERT_PWD = "fnefpay.gmSignCert.pwd";
	/** 配置文件中国密验签证书路径 */
	private static final String SDK_GM_VERIFY_CERT_DIR = "fnefpay.gmVerifyCert.dir";
	/** 配置文件中国密验签证书序号 */
	public static final String SDK_GMVALIDATECERT_SN ="fnefpay.gmValidateCert.sn";

	/** 操作对象 */
	private static FnefPayConfig config = new FnefPayConfig();
	/** 属性文件对象 */
	private Properties properties;

	private FnefPayConfig() {
		super();
	}

	/**
	 *  获取config对象.
	 * @return
	 */
	public static FnefPayConfig getConfig() {
		return config;
	}

	/**
	 * 从properties文件加载
	 *
	 * @param rootPath
	 *            不包含文件名的目录.
	 */
	public void loadPropertiesFromPath(String rootPath) {
		if (rootPath != null && !"".equals(rootPath.trim())) {
//			LogUtils.getLogger().info("从路径读取配置文件: " + rootPath+File.separator+FILE_NAME);
			File file = new File(rootPath + File.separator + FILE_NAME);
			InputStream in = null;
			if (file.exists()) {
				try {
					in = new FileInputStream(file);
					properties = new Properties();
					properties.load(in);
					loadProperties(properties);
				} catch (FileNotFoundException e) {
//					LogUtils.getLogger().error(e.getMessage(), e);
				} catch (IOException e) {
//					LogUtils.getLogger().error(e.getMessage(), e);
				} finally {
					if (null != in) {
						try {
							in.close();
						} catch (IOException e) {
//							LogUtils.getLogger().error(e.getMessage(), e);
						}
					}
				}
			} else {
				// 由于此时可能还没有完成LOG的加载，因此采用标准输出来打印日志信息
//				LogUtils.getLogger().error(rootPath + FILE_NAME + "不存在,加载参数失败");
			}
		} else {
			loadPropertiesFromSrc();
		}
	}

	/**
	 * 从classpath路径下加载配置参数
	 */
	public void loadPropertiesFromSrc() {
		InputStream in = null;
		try {
//			LogUtils.getLogger().info("从classpath: " +FnefPayConfig.class.getClassLoader().getResource("").getPath()+" 获取属性文件"+FILE_NAME);
			in = FnefPayConfig.class.getClassLoader().getResourceAsStream(FILE_NAME);
			if (null != in) {
				properties = new Properties();
				try {
					properties.load(in);
				} catch (IOException e) {
					throw e;
				}
			} else {
//				LogUtils.getLogger().error(FILE_NAME + "属性文件未能在classpath指定的目录下 "+FnefPayConfig.class.getClassLoader().getResource("").getPath()+" 找到!");
				return;
			}
			loadProperties(properties);
		} catch (IOException e) {
//			LogUtils.getLogger().error(e.getMessage(), e);
		} finally {
			if (null != in) {
				try {
					in.close();
				} catch (IOException e) {
//					LogUtils.getLogger().error(e.getMessage(), e);
				}
			}
		}
	}

	public void loadProperties(Properties pro) {
//		LogUtils.getLogger().info("开始从属性文件中加载配置项");
		String value = null;

		value = pro.getProperty(SDK_SIGNCERT_PATH);
		if (!FnefPayUtils.isEmpty(value)) {
			this.signCertPath = value.trim();
//			LogUtils.getLogger().info("配置项：国际私钥签名证书路径==>"+SDK_SIGNCERT_PATH +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_SIGNCERT_PWD);
		if (!FnefPayUtils.isEmpty(value)) {
			this.signCertPwd = value.trim();
//			LogUtils.getLogger().info("配置项：国际私钥签名证书密码==>"+SDK_SIGNCERT_PWD +" 已加载");
		}
		value = pro.getProperty(SDK_VALIDATECERT_DIR);
		if (!FnefPayUtils.isEmpty(value)) {
			this.validateCertDir = value.trim();
//			LogUtils.getLogger().info("配置项：国际验证签名证书路径(这里配置的是目录，不要指定到公钥文件)==>"+SDK_VALIDATECERT_DIR +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.backRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台生产地址==>"+SDK_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GH11_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gh11BackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台一轮一地址==>"+SDK_GH11_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GH12_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gh12BackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台一轮二地址==>"+SDK_GH12_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GH13_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gh13BackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台一轮三地址==>"+SDK_GH13_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GH21_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gh21BackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台二轮一地址==>"+SDK_GH21_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GH22_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gh22BackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台二轮二地址==>"+SDK_GH22_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GH23_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gh23BackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台二轮三地址==>"+SDK_GH23_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GHZSC_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.ghzscBackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台准生产地址==>"+SDK_GHZSC_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GHYZ_BACK_URL);
		if (!FnefPayUtils.isEmpty(value)) {
			this.ghyzBackRequestUrl = value.trim();
//			LogUtils.getLogger().info("配置项：收银台验证地址==>"+SDK_GHYZ_BACK_URL +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_CONNECT_TIME_OUT);
		if (!FnefPayUtils.isEmpty(value)) {
			this.connectTimeOut = value.trim();
//			LogUtils.getLogger().info("配置项：请求收银台连接超时时间==>"+SDK_CONNECT_TIME_OUT +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_READ_TIME_OUT);
		if (!FnefPayUtils.isEmpty(value)) {
			this.readTimeOut = value.trim();
//			LogUtils.getLogger().info("配置项：请求收银台读取超时时间==>"+SDK_READ_TIME_OUT +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_MERCHANT_ID);
		if (!FnefPayUtils.isEmpty(value)) {
			this.merchantId = value.trim();
//			LogUtils.getLogger().info("配置项：商户编号==>"+SDK_MERCHANT_ID +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_TERMINAL_ID);
		if (!FnefPayUtils.isEmpty(value)) {
			this.terminalId = value.trim();
//			LogUtils.getLogger().info("配置项：终端编号==>"+SDK_TERMINAL_ID +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_IF_VALIDATE_REMOTE_CERT);
		if (!FnefPayUtils.isEmpty(value)) {
			if ( FnefPayConstants.TRUE_STRING.equals(value.trim())) {
				this.ifValidateRemoteCert = true;
			}
			else {
				this.ifValidateRemoteCert = false;
			}
//			LogUtils.getLogger().info("配置项：是否验证https证书==>"+SDK_IF_VALIDATE_REMOTE_CERT +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_SIGN_METHOD);
		if (!FnefPayUtils.isEmpty(value)) {
			this.signMethod = value.trim();
//			LogUtils.getLogger().info("配置项：签名方式==>"+SDK_SIGN_METHOD +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_MERINSTID);
		if (!FnefPayUtils.isEmpty(value)) {
			this.merInstId = value.trim();
//			LogUtils.getLogger().info("配置项：商户标识==>"+SDK_MERINSTID +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_VALIDATECERT_SN);
		if (!FnefPayUtils.isEmpty(value)) {
			this.validateCertSn = value.trim();
//			LogUtils.getLogger().info("配置项：国际验签证书序号==>"+SDK_VALIDATECERT_SN +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GM_SIGN_CERT_PATH);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gmSignCertPath = value.trim();
//			LogUtils.getLogger().info("配置项：国密私钥签名证书路径==>"+SDK_SIGNCERT_PATH +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GM_SIGN_CERT_PWD);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gmSignCertPwd = value.trim();
//			LogUtils.getLogger().info("配置项：国密私钥签名证书密码==>"+SDK_SIGNCERT_PWD +" 已加载");
		}
		value = pro.getProperty(SDK_GM_VERIFY_CERT_DIR);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gmVerifyCertDir = value.trim();
//			LogUtils.getLogger().info("配置项：国密验证签名证书路径(这里配置的是目录，不要指定到公钥文件)==>"+SDK_VALIDATECERT_DIR +"==>"+ value+" 已加载");
		}
		value = pro.getProperty(SDK_GMVALIDATECERT_SN);
		if (!FnefPayUtils.isEmpty(value)) {
			this.gmValidateCertSn = value.trim();
//			LogUtils.getLogger().info("配置项：国密验签证书序号==>"+SDK_VALIDATECERT_SN +"==>"+ value+" 已加载");
		}
	}

	public String getBackRequestUrl() {
		return backRequestUrl;
	}

	public void setBackRequestUrl(String backRequestUrl) {
		this.backRequestUrl = backRequestUrl;
	}

	public String getSignCertPath() {
		return signCertPath;
	}

	public void setSignCertPath(String signCertPath) {
		this.signCertPath = signCertPath;
	}

	public String getSignCertPwd() {
		return signCertPwd;
	}

	public void setSignCertPwd(String signCertPwd) {
		this.signCertPwd = signCertPwd;
	}

	public String getValidateCertDir() {
		return validateCertDir;
	}

	public void setValidateCertDir(String validateCertDir) {
		this.validateCertDir = validateCertDir;
	}

	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	public String getSignMethod() {
		return signMethod;
	}

	public void setSignMethod(String signMethod) {
		this.signMethod = signMethod;
	}

	public String getMerInstId() {
		return merInstId;
	}

	public void setMerInstId(String merInstId) {
		this.merInstId = merInstId;
	}

	public String getValidateCertSn() {
		return validateCertSn;
	}

	public void setValidateCertSn(String validateCertSn) {
		this.validateCertSn = validateCertSn;
	}

	public String getGh11BackRequestUrl() {
		return gh11BackRequestUrl;
	}

	public void setGh11BackRequestUrl(String gh11BackRequestUrl) {
		this.gh11BackRequestUrl = gh11BackRequestUrl;
	}

	public String getGh12BackRequestUrl() {
		return gh12BackRequestUrl;
	}

	public void setGh12BackRequestUrl(String gh12BackRequestUrl) {
		this.gh12BackRequestUrl = gh12BackRequestUrl;
	}

	public String getGh13BackRequestUrl() {
		return gh13BackRequestUrl;
	}

	public void setGh13BackRequestUrl(String gh13BackRequestUrl) {
		this.gh13BackRequestUrl = gh13BackRequestUrl;
	}

	public String getGh21BackRequestUrl() {
		return gh21BackRequestUrl;
	}

	public void setGh21BackRequestUrl(String gh21BackRequestUrl) {
		this.gh21BackRequestUrl = gh21BackRequestUrl;
	}

	public String getGh22BackRequestUrl() {
		return gh22BackRequestUrl;
	}

	public void setGh22BackRequestUrl(String gh22BackRequestUrl) {
		this.gh22BackRequestUrl = gh22BackRequestUrl;
	}

	public String getGh23BackRequestUrl() {
		return gh23BackRequestUrl;
	}

	public void setGh23BackRequestUrl(String gh23BackRequestUrl) {
		this.gh23BackRequestUrl = gh23BackRequestUrl;
	}

	public String getGhzscBackRequestUrl() {
		return ghzscBackRequestUrl;
	}

	public void setGhzscBackRequestUrl(String ghzscBackRequestUrl) {
		this.ghzscBackRequestUrl = ghzscBackRequestUrl;
	}

	public String getGhyzBackRequestUrl() {
		return ghyzBackRequestUrl;
	}

	public void setGhyzBackRequestUrl(String ghyzBackRequestUrl) {
		this.ghyzBackRequestUrl = ghyzBackRequestUrl;
	}

	public String getGmSignCertPath() {
		return gmSignCertPath;
	}

	public void setGmSignCertPath(String gmSignCertPath) {
		this.gmSignCertPath = gmSignCertPath;
	}

	public String getGmSignCertPwd() {
		return gmSignCertPwd;
	}

	public void setGmSignCertPwd(String gmSignCertPwd) {
		this.gmSignCertPwd = gmSignCertPwd;
	}

	public String getGmVerifyCertDir() {
		return gmVerifyCertDir;
	}

	public void setGmVerifyCertDir(String gmVerifyCertDir) {
		this.gmVerifyCertDir = gmVerifyCertDir;
	}

	public String getGmValidateCertSn() {
		return gmValidateCertSn;
	}

	public void setGmValidateCertSn(String gmValidateCertSn) {
		this.gmValidateCertSn = gmValidateCertSn;
	}

	public String getConnectTimeOut() {
		return connectTimeOut;
	}

	public void setConnectTimeOut(String connectTimeOut) {
		this.connectTimeOut = connectTimeOut;
	}

	public String getReadTimeOut() {
		return readTimeOut;
	}

	public void setReadTimeOut(String readTimeOut) {
		this.readTimeOut = readTimeOut;
	}

	public String getMerchantId() {
		return merchantId;
	}

	public void setMerchantId(String merchantId) {
		this.merchantId = merchantId;
	}

	public String getTerminalId() {
		return terminalId;
	}

	public void setTerminalId(String terminalId) {
		this.terminalId = terminalId;
	}

	public  Boolean getIfValidateRemoteCert() {
		return ifValidateRemoteCert;
	}

	public void setIfValidateRemoteCert( Boolean ifValidateRemoteCert) {
		this.ifValidateRemoteCert = ifValidateRemoteCert;
	}
}
