package com.fshows.util.fjnx;

import com.fshows.util.fnefpay.gm.PKCS12_SM2;
import com.fshows.util.fnefpay.gm.X509Cert_SM2;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Sequence;
import shaded.org.bouncycastle.util.encoders.Base64;
import shaded.org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;

/**
 * 证书秘钥转为HexString秘钥工具类
 */
public class Sm2Cert2HexUtil {

    /**
     * 证书生成的Base64格式公钥转为Hex格式公钥
     *
     * @param certPublicKey 证书公钥字符串
     * @return 16进制字符串公钥
     */
    public static String cert2HexPublicKey(String certPublicKey) throws Exception {
        if (null == certPublicKey || certPublicKey.trim().length() == 0) {
            throw new IllegalArgumentException("公钥不能空");
        }
        X509Cert_SM2 certSm2 = new X509Cert_SM2(certPublicKey.getBytes());
        return Hex.toHexString(certSm2.getPublicKey());
    }

    /**
     * 证书生成的Base64格式私钥转为Hex格式私钥
     *
     * @param certPrivateKey 证书私钥
     * @param certPassword   证书密码
     * @return Hex格式私钥
     */
    public static String cert2HexPrivateKey(String certPrivateKey, String certPassword) throws Exception {
        if (certPrivateKey == null) {
            throw new IllegalArgumentException("私钥不能空");
        }
        if (certPassword == null) {
            throw new IllegalArgumentException("密码不能为空");
        }
        ASN1Sequence privateASN1Sequence = ASN1Sequence.getInstance(Base64.decode(certPrivateKey));
        if ((privateASN1Sequence == null) || (privateASN1Sequence.size() != 3)) {
            throw new Exception("invalid SM2File encoding");
        }
        ASN1Sequence privateInfo = (ASN1Sequence) privateASN1Sequence.getObjectAt(1);
        ASN1Sequence publicInfo = (ASN1Sequence) privateASN1Sequence.getObjectAt(2);
        if (privateInfo.size() != 3) {
            throw new Exception("the sm2 file is not right format,can not get the private part");
        }
        if (publicInfo.size() != 2) {
            throw new Exception("the sm2 file is not right format.can not get the public part");
        }
        ASN1OctetString priOctString = (ASN1OctetString) privateInfo.getObjectAt(2);
        byte[] encryptedData = priOctString.getOctets();
        String dBytes = PKCS12_SM2.SM4DecryptDBytes(certPassword, encryptedData);
        BigInteger privateKey = new BigInteger(dBytes, 16);
        return privateKey.toString(16);
    }

}
