/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 银联JS支付 response
 *
 * @author
 * @version FjnxUnionJsapiPayRes.java, v 0.1 2024-11-26 15:07:52
 */
@Data
public class FjnxUnionJsapiPayRes extends FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555980660038L;


    /**
     * 商户编号
     * (选填)
     */
    private String mchtNo;

    /**
     * 交易金额，单位为元，精确到小数点后两位,带小数点
     * (选填)
     */
    private String txnAmt;

    /**
     * 支付页面，URL解码后，重定向到支付页面，即可拉起支付控件完成支付
     * (选填)
     */
    private String payUrl;

}