/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 被扫支付接口 response
 *
 * @author
 * @version FjnxScanOrderCreateRes.java, v 0.1 2024-11-26 14:37:49
 */
@Data
public class FjnxScanOrderCreateRes extends FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555533275752L;


    /**
     * 商户编号
     * (选填)
     */
    private String mchtNo;

    /**
     * 交易金额
     * (选填)
     */
    private String txnAmt;

    /**
     * 支付方式，WX--微信, AL--支付宝, UN--银联二维码
     * (选填)
     */
    private String payType;

    /**
     * 支付机构订单号
     * (选填)
     */
    private String outOrderNo;

    /**
     * 商户实收/实退金额，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    private String mchtSettleAmt;

    /**
     * 商户优惠金额，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    private String mchtDiscountAmt;

}