/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 收银台退款接口 response
 *
 * @author
 * @version FjnxOrderRefundRes.java, v 0.1 2024-11-26 15:23:32
 */
@Data
public class FjnxOrderRefundRes extends FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555571110246L;


    /**
     * 原请求方交易日期
     * (选填)
     */
    private String orgTradeDate;

    /**
     * 原请求方交易流水号
     * (选填)
     */
    private String orgTradeNo;

    /**
     * 原平台流水号
     * (选填)
     */
    private String orgOrderNo;

    /**
     * 原平台交易日期
     * (选填)
     */
    private String orgOrderDate;

    /**
     * 原平台交易时间
     * (选填)
     */
    private String orgOrderTime;

    /**
     * 支付方式，WX--微信, AL--支付宝, UN--银联二维码, UP--银联无卡, NP--银行卡线下
     * (选填)
     */
    private String payType;

    /**
     * 退款金额，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    private String txnAmt;

    /**
     * 商户实收/实退金额，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    private String mchtSettleAmt;

    /**
     * 消费确认后退货剩余金额，担保支付返回，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    private String payConfirmSurplusAmout;

    /**
     * 消费确认后退货剩余总次数，担保支付返回
     * (选填)
     */
    private String payConfirmSurplusCount;

    /**
     * 消费确认前退货剩余金额，担保支付返回，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    private String surplusAmout;

    /**
     * 消费确认前退货剩余总次数，担保支付返回
     * (选填)
     */
    private String surplusCount;

    /**
     * 支付机构订单号，银联无卡退款、担保支付返回
     * (选填)
     */
    private String outOrderNo;

    /**
     * 清算日期，银联无卡退款、担保支付返回
     * (选填)
     */
    private String settleDate;

    /**
     * 商户退款单号
     * (选填)
     */
    private String outRefundNo;

    /**
     * 商户号
     * (选填)
     */
    private String mchtNo;
}