/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 订单查询请求 response
 *
 * @author
 * @version FjnxOrderQueryRes.java, v 0.1 2024-11-26 15:13:59
 */
@Data
public class FjnxOrderQueryRes extends FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555542363054L;


    /**
     * 商户号
     * (选填)
     */
    private String mchtNo;

    /**
     * 交易金额，单位为元，精确到小数点后两位,带小数点
     * (选填)
     */
    private String txnAmt;

    /**
     * 原请求方交易日期
     * (选填)
     */
    private String orgTradeDate;

    /**
     * 原请求方交易流水号
     * (选填)
     */
    private String orgTradeNo;

    /**
     * 原平台流水号
     * (选填)
     */
    private String orgOrderNo;

    /**
     * 原平台交易日期
     * (选填)
     */
    private String orgOrderDate;

    /**
     * 原平台交易时间
     * (选填)
     */
    private String orgOrderTime;

    /**
     * 第三方支付订单号
     * (选填)
     */
    private String orgOutOrderNo;

    /**
     * 支付方式，WX--微信, AL--支付宝, UN--银联二维码, UP--银联无卡, NP--银行卡线下
     * (选填)
     */
    private String payType;

    /**
     * 原交易状态，FAIL--交易失败 INIT--初始化 PROCESSING--处理中 SUCCESS--交易成功 UNKNOWN--交易超时 CLOSED--已关单
     * (选填)
     */
    private String orgStatus;

    /**
     * 原交易应答码，000000--交易成功 999999--主机超时
     * (选填)
     */
    private String orgPayRspCode;

    /**
     * 原交易应答信息
     * (选填)
     */
    private String orgPayRspDesc;

    /**
     * 商户实收/实退金额
     * (选填)
     */
    private String mchtSettleAmt;

    /**
     * 商户优惠金额
     * (选填)
     */
    private String mchtDiscountAmt;

    /**
     * 付款账号类型
     * (选填)
     */
    private String payAcctType;

    /**
     * 清算日期
     * (选填)
     */
    private String settleDate;

    /**
     * 授权码
     * (选填)
     */
    private String authCode;

    /**
     * 子订单信息，数组形式的JSON字符串
     * 字段内容参考：FjnxSubOrderInfoRes
     * (选填)
     */
    private String orderInf;

    /**
     * 通道流水号（微信/支付宝订单详情上的商户单号）
     */
    private String pmcNo;
}