/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 * @author liluqing
 * @version FjnxBizRequest.java, v 0.1 2024-11-21 下午3:53
 */
@Data
public class FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = 7221327796066522380L;

    /**
     * 平台流水号
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 平台交易日期，格式为YYYYMMDD
     * (选填)
     */
    @Length(max = 8, message = "orderDate长度不能超过8")
    private String orderDate;

    /**
     * 平台交易时间，格式为HHMMSS
     * (选填)
     */
    @Length(max = 6, message = "orderTime长度不能超过6")
    private String orderTime;

    /**
     * 请求方流水号，原样返回
     * (必填)
     */
    @Length(max = 32, message = "tradeNo长度不能超过32")
    private String tradeNo;

    /**
     * 请求方交易日期，原样返回
     * (必填)
     */
    @Length(max = 8, message = "tradeDate长度不能超过8")
    private String tradeDate;

    /**
     * 请求交易时间，原样返回
     * (必填)
     */
    @Length(max = 6, message = "tradeTime长度不能超过6")
    private String tradeTime;
}