/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 支付宝(app支付、服务窗支付) response
 *
 * @author
 * @version FjnxAlipayJsapiPayRes.java, v 0.1 2024-11-26 14:52:13
 */
@Data
public class FjnxAlipayJsapiPayRes extends FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555990317326L;


    /**
     * 商户编号
     * (选填)
     */
    private String mchtNo;

    /**
     * 交易金额，单位为元，精确到小数点后两位,带小数点
     * (选填)
     */
    private String txnAmt;

    /**
     * 用于JSAPI唤起支付宝支付控件，需先去掉前2位再传给JS（Base64数据，需要解码）
     * (选填)
     */
    private String prepayId;

    /**
     * 支付宝服务窗会出现
     * (选填)
     */
    private String payUrl;

}