/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 微信公众号/小程序/APP支付下单接口 request
 *
 * @author
 * @version FjnxWxJsapiPayReq.java, v 0.1 2024-11-26 14:57:10
 */
@Data
public class FjnxWxJsapiPayReq extends FjnxBizRequest implements Serializable {

    private static final long serialVersionUID = -2213838555712088353L;


    /**
     * 支付场景，WEB--网上商城，H5--页面收银台，APPLETS--商家小程序，OFFICIAL--商家公众号，POS--pos终端，APP--商户APP，OTHER--其他场景
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "payScene长度不能超过8")
    private String payScene;

    /**
     * 内部用户号，用于内外部客户号绑定，组合支付时核心客户号
     * (特殊必填)
     */
    @Length(max = 25, message = "memberNo长度不能超过25")
    private String memberNo;

    /**
     * 外部客户号，用于内外部客户号绑定
     * (特殊必填)
     */
    @Length(max = 15, message = "customNo长度不能超过15")
    private String customNo;

    /**
     * 交易金额，单位为元，精确到小数点后两位，带小数点
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "txnAmt长度不能超过12")
    private String txnAmt;

    /**
     * 业务类型，SCAN--主扫支付，OFFICIAL--公众号支付、小程序，APP--APP支付
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "tradeType长度不能超过16")
    private String tradeType;

    /**
     * 商户订单信息描述，最大长度为128
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "merchantOrderInfo长度不能超过128")
    private String merchantOrderInfo;

    /**
     * 商户订单详细信息，包括商品编号、商品名称、商品数量、商品单价等
     * (必填)
     */
    @NotNull
    private List<FjnxMerchantOrderInfoDtlReq> merchantOrderInfoDtl;

    /**
     * 备注信息，用于对账单展示，最大长度为128
     * (特殊必填)
     */
    @Length(max = 128, message = "attach长度不能超过128")
    private String attach;

    /**
     * 扫码支付授权码，设备读取用户展示的条码或二维码信息
     * (选填)
     */
    @Length(max = 18, message = "userAhrCd长度不能超过18")
    private String userAhrCd;

    /**
     * 订单生成时间，格式为yyyyMMddHHmmss，最大长度为14
     * (必填)
     */
    @NotBlank
    @Length(max = 14, message = "timeStart长度不能超过14")
    private String timeStart;

    /**
     * 订单失效时间，默认生成时间+5分钟，最大长度为14
     * 格式：yyyyMMddHHmmss
     * (特殊必填)
     */
    @Length(max = 14, message = "timeExpire长度不能超过14")
    private String timeExpire;

    /**
     * 用户在银行appid下的唯一标识，微信app支付只能传subOpenid与subAppid
     * (选填)
     */
    private String openid;

    /**
     * 子商户方式下单时传送，最大长度为32
     * (选填)
     */
    @Length(max = 32, message = "subOpenid长度不能超过32")
    private String subOpenid;

    /**
     * 子商户方式下单时传送，最大长度为32
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 支付结果异步通知标识，Y--通知，N--不通知，最大长度为1
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "isNotifyFlg长度不能超过1")
    private String isNotifyFlg;

    /**
     * 支付结果异步通知标识为Y时必输，最大长度为128
     * (特殊必填)
     */
    @Length(max = 128, message = "notifyUrl长度不能超过128")
    private String notifyUrl;

    /**
     * 交易结束后点击返回按钮跳转至商户指定页面，需填入完整URL，最大长度为128
     * (特殊必填)
     */
    @Length(max = 128, message = "merUrl长度不能超过128")
    private String merUrl;

    /**
     * 支付通道，OFFLINE--线下支付，ONLINE--线上支付，最大长度为16
     * (特殊必填)
     */
    @Length(max = 16, message = "payChnl长度不能超过16")
    private String payChnl;

    /**
     * 担保支付标识，1--担保订单，0--普通订单，最大长度为1
     * (特殊必填)
     */
    @Length(max = 1, message = "grtFlag长度不能超过1")
    private String grtFlag;

    /**
     * 终端发起交易需要上送
     * (选填)
     */
    private List<FjnxTermInfoReq> termInfo;

}