/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 银联JS支付 request
 *
 * @author
 * @version FjnxUnionJsapiPayReq.java, v 0.1 2024-11-26 15:07:52
 */
@Data
public class FjnxUnionJsapiPayReq extends FjnxBizRequest implements Serializable {

    private static final long serialVersionUID = -2213838555770150776L;


    /**
     * 支付场景，WEB--网上商城 H5--页面收银台 APPLETS--商家小程序 OFFICIAL--商家公众号 POS--pos终端 APP--商户APP、 OTHER--其他场景
     * (选填)
     */
    @Length(max = 8, message = "payScene长度不能超过8")
    private String payScene;

    /**
     * 交易金额，单位为元，精确到小数点后两位,带小数点
     * (选填)
     */
    @Length(max = 12, message = "txnAmt长度不能超过12")
    private String txnAmt;

    /**
     * 商户订单信息描述
     * (选填)
     */
    @Length(max = 128, message = "merchantOrderInfo长度不能超过128")
    private String merchantOrderInfo;

    /**
     * 商户订单信息详情
     * (选填)
     */
    private List<FjnxMerchantOrderInfoDtlReq> merchantOrderInfoDtl;

    /**
     * 备注，在对账单展示
     * (选填)
     */
    @Length(max = 128, message = "attach长度不能超过128")
    private String attach;

    /**
     * 用户开放标识
     * (选填)
     */
    @Length(max = 128, message = "userOpenId长度不能超过128")
    private String userOpenId;

    /**
     * 用户确认付款时IP
     * (选填)
     */
    @Length(max = 40, message = "customerIp长度不能超过40")
    private String customerIp;

    /**
     * 订单生成时间
     * (选填)
     */
    @Length(max = 14, message = "timeStart长度不能超过14")
    private String timeStart;

    /**
     * 订单失效时间，不输入默认生成时间+5分钟
     * (选填)
     */
    @Length(max = 14, message = "timeExpire长度不能超过14")
    private String timeExpire;

    /**
     * 支付结果异步通知标识，Y--通知 N--不通知
     * (选填)
     */
    @Length(max = 1, message = "isNotifyFlg长度不能超过1")
    private String isNotifyFlg;

    /**
     * 支付结果异步通知标识为Y时必输
     * (选填)
     */
    @Length(max = 128, message = "notifyUrl长度不能超过128")
    private String notifyUrl;

    /**
     * 二维码类型，0--动态码 1--静态码
     * (选填)
     */
    @Length(max = 1, message = "qrCodeType长度不能超过1")
    private String qrCodeType;

    /**
     * 前台页面通知，需上送
     * (选填)
     */
    @Length(max = 128, message = "frontNotifyUrl长度不能超过128")
    private String frontNotifyUrl;

    /**
     * 前台页面失败通知地址
     * (选填)
     */
    @Length(max = 128, message = "frontFailNotifyUrl长度不能超过128")
    private String frontFailNotifyUrl;

    /**
     * 服务商机构标识码
     * (选填)
     */
    @Length(max = 8, message = "serviceInstIdCode长度不能超过8")
    private String serviceInstIdCode;

    /**
     * 二维码，可上送行业码首页地址
     * (选填)
     */
    private String qrCode;

    /**
     * 用户授权码，与获取银联JS支付用户标识上送的用户授权码一致
     * (选填)
     */
    private String userAuthCode;

    /**
     * 终端发起交易需要上送
     * (选填)
     */
    private List<FjnxTermInfoReq> termInfo;
}