/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 收银台退款接口 request
 *
 * @author
 * @version FjnxOrderRefundReq.java, v 0.1 2024-11-26 15:23:32
 */
@Data
public class FjnxOrderRefundReq extends FjnxBizRequest implements Serializable {

    private static final long serialVersionUID = -2213838555370595375L;


    /**
     * 请求交易类型，RT001--普通二维码退款, RT002--担保退款, RT003--银联无卡退款
     * (选填)
     */
    @Length(max = 6, message = "actionType长度不能超过6")
    private String actionType;

    /**
     * 退款金额，单位为元，精确到小数点后两位,带小数点，当退货类型为01时，退款金额不能大于原消费确认交易金额；当退货类型为02时，退款金额不能大于未消费确认总金额
     * (选填)
     */
    @Length(max = 12, message = "txnAmt长度不能超过12")
    private String txnAmt;

    /**
     * 原请求方交易流水号，担保退款、无卡退款时，原请求方交易流水号和原请求方交易日期或原平台流水号和原平台交易日期必须传一组
     * (选填)
     */
    @Length(max = 32, message = "orgTradeNo长度不能超过32")
    private String orgTradeNo;

    /**
     * 原请求方交易日期
     * (选填)
     */
    @Length(max = 8, message = "orgTradeDate长度不能超过8")
    private String orgTradeDate;

    /**
     * 原平台流水号，担保退款、无卡退款时，原请求方交易流水号和原请求方交易日期或原平台流水号和原平台交易日期必须传一组
     * (选填)
     */
    @Length(max = 32, message = "orgOrderNo长度不能超过32")
    private String orgOrderNo;

    /**
     * 原平台交易日期
     * (选填)
     */
    @Length(max = 8, message = "orgOrderDate长度不能超过8")
    private String orgOrderDate;

    /**
     * 商户退款单号，非重复退款交易该值与tradeNo一致，同笔退款该值与上次商户退款单号一致
     * (选填)
     */
    @Length(max = 32, message = "outRefundNo长度不能超过32")
    private String outRefundNo;

    /**
     * 退货类型，担保退款必输，01--代表消费确认后退货，02--代表消费确认前退货
     * (选填)
     */
    @Length(max = 2, message = "refundType长度不能超过2")
    private String refundType;

    /**
     * 附加信息，备注，在对账单展示
     * (选填)
     */
    @Length(max = 128, message = "attach长度不能超过128")
    private String attach;

}