/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 订单查询请求 request
 *
 * @author
 * @version FjnxOrderQueryReq.java, v 0.1 2024-11-26 15:13:58
 */
@Data
public class FjnxOrderQueryReq extends FjnxBizRequest implements Serializable {

    private static final long serialVersionUID = -2213838555658791880L;


    /**
     * 请求交易类型, QT001--订单查询 QT002--订单退款查询 QT003--二维码预授权交易状态结果查询 QT004--银联无卡支付交易状态结果查询 QT005--担保支付交易状态查询
     * (选填)
     */
    @Length(max = 6, message = "actionType长度不能超过6")
    private String actionType;

    /**
     * 原请求方交易流水号（商户发起支付或退款时的流水号）
     * (选填)
     */
    @Length(max = 32, message = "orgTradeNo长度不能超过32")
    private String orgTradeNo;

    /**
     * 与请求方交易流水号同时存在
     * (选填)
     */
    @Length(max = 8, message = "orgTradeDate长度不能超过8")
    private String orgTradeDate;

    /**
     * 原请求方交易流水号和原请求方交易日期或原平台流水号和原平台交易日期必须传一组
     * (选填)
     */
    @Length(max = 32, message = "orgOrderNo长度不能超过32")
    private String orgOrderNo;

    /**
     * 与原平台流水号同时存在
     * (选填)
     */
    @Length(max = 8, message = "orgOrderDate长度不能超过8")
    private String orgOrderDate;

}