/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 * @author liluqing
 * @version FjnxMerchantOrderInfoDtlReq.java, v 0.1 2024-11-26 下午2:41
 */
@Data
public class FjnxMerchantOrderInfoDtlReq implements Serializable {


    private static final long serialVersionUID = 5706170543173972541L;


    /**
     * 商品编号
     * (选填)
     */
    @Length(max = 32, message = "goodsId长度不能超过32")
    private String goodsId;

    /**
     * 商品名称
     * (选填)
     */
    @Length(max = 256, message = "goodsName长度不能超过256")
    private String goodsName;

    /**
     * 商品数量
     * (选填)
     */
    @Length(max = 10, message = "goodsNum长度不能超过10")
    private String goodsNum;

    /**
     * 商品单价，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    @Length(max = 12, message = "goodsPrice长度不能超过12")
    private String goodsPrice;
}