/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 福建农商银行SDK请求头
 *
 * @author liluqing
 * @version FjnxHeadRequest.java, v 0.1 2024-11-21 下午3:48
 */
@Data
public class FjnxHeadRequest implements Serializable {

    /**
     * 证书标识
     * 平台接入时为平台证书标识，通过收银台运管上传公钥证书时由收银台生成
     */
    private String merInstId;

    /**
     * 机构标识
     * 收银台证书标识固定值：S000000002
     */
    private String sysInstId;

    /**
     * 数字信封
     * 使用收银台公钥加密
     */
    private String digitalEnvelope;

    /**
     * 签名
     */
    private String signature;

    /**
     * 算法类型
     * 03-sm2 国密算法
     * 05-mac版
     */
    private String signType;
}