/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gj;

import com.fshows.util.fnefpay.sdk.FnefPayConfig;
import com.fshows.util.fnefpay.sdk.FnefPayUtils;
import com.fshows.util.fnefpay.util.CerFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtils_RSA {
    private static KeyStore keyStore = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();
    private static final Map<String, KeyStore> keyStoreMap = new ConcurrentHashMap<String, KeyStore>();

    private static void init() {
        try {
            CertUtils_RSA.addProvider();
            CertUtils_RSA.initSignCert();
            CertUtils_RSA.initValidateCertFromDir();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private static void initSignCert() {
        if (!"01".equals(FnefPayConfig.getConfig().getSignMethod())) {
            return;
        }
        if (FnefPayConfig.getConfig().getSignCertPath() == null || FnefPayConfig.getConfig().getSignCertPwd() == null) {
            return;
        }
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtils_RSA.getKeyInfo(FnefPayConfig.getConfig().getSignCertPath(), FnefPayConfig.getConfig().getSignCertPwd());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        if (!"01".equals(FnefPayConfig.getConfig().getSignMethod())) {
            return;
        }
        certMap.clear();
        String dir = FnefPayConfig.getConfig().getValidateCertDir();
        if (FnefPayUtils.isEmpty(dir)) {
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            return;
        }
        catch (CertificateException e) {
            return;
        }
        File fileDir = new File(dir);
        File[] files = fileDir.listFiles(new CerFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                in = new FileInputStream(file.getAbsolutePath());
                X509Certificate validateCert = (X509Certificate)cf.generateCertificate(in);
                if (validateCert == null) continue;
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                continue;
            }
            catch (CertificateException certificateException) {
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, FnefPayConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            return null;
        }
        catch (UnrecoverableKeyException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static PublicKey getValidatePublicKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtils_RSA.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyInfo(String pfxkeyfile, String keypwd) throws IOException {
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    private static void printProviders() {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
        }
    }

    private static void loadSignCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtils_RSA.getKeyInfo(certFilePath, certPwd);
            keyStoreMap.put(certFilePath, keyStore);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!keyStoreMap.containsKey(certPath)) {
            CertUtils_RSA.loadSignCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = keyStoreMap.get(certPath).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStoreMap.get(certPath).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            return null;
        }
        catch (UnrecoverableKeyException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    static {
        CertUtils_RSA.init();
    }
}

