/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fjnx;

import com.fshows.util.fjnx.SM2KeyPair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Utils {
    private static final Logger log = LoggerFactory.getLogger(SM2Utils.class);
    private static final String EC = "EC";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();

    public static SM2KeyPair<byte[], BigInteger> genKeyPair() {
        return SM2Utils.genKeyPair(false);
    }

    public static SM2KeyPair<byte[], BigInteger> genKeyPair(boolean compressed) {
        KeyPairGeneratorSpi.EC spi = new KeyPairGeneratorSpi.EC();
        X9ECParameters parameters = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        ECParameterSpec parameterSpec = new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN());
        SecureRandom secureRandom = new SecureRandom();
        spi.initialize((AlgorithmParameterSpec)parameterSpec, secureRandom);
        KeyPair asymmetricCipherKeyPair = spi.generateKeyPair();
        BCECPublicKey publicKeyParameters = (BCECPublicKey)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        byte[] publicKey = ecPoint.getEncoded(compressed);
        BCECPrivateKey privateKeyParameters = (BCECPrivateKey)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        return new SM2KeyPair<byte[], BigInteger>(publicKey, intPrivateKey);
    }

    public static SM2KeyPair<String, String> genKeyPairAsHex() {
        return SM2Utils.genKeyPairAsHex(false);
    }

    public static SM2KeyPair<String, String> genKeyPairAsHex(boolean compressed) {
        SM2KeyPair<byte[], BigInteger> pair = SM2Utils.genKeyPair(compressed);
        return new SM2KeyPair<String, String>(Hex.toHexString((byte[])pair.getPublic()), pair.getPrivate().toString(16));
    }

    public static SM2KeyPair<String, String> genKeyPairAsBase64() {
        return SM2Utils.genKeyPairAsBase64(false);
    }

    public static SM2KeyPair<String, String> genKeyPairAsBase64(boolean compressed) {
        SM2KeyPair<byte[], BigInteger> pair = SM2Utils.genKeyPair(compressed);
        return new SM2KeyPair<String, String>(BASE64_ENCODER.encodeToString(pair.getPublic()), BASE64_ENCODER.encodeToString(pair.getPrivate().toByteArray()));
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data) {
        return SM2Utils.encrypt(publicKey, data, SM2Engine.Mode.C1C3C2);
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data, SM2Engine.Mode mode) {
        ASN1ObjectIdentifier sm2p256v1 = GMObjectIdentifiers.sm2p256v1;
        X9ECParameters parameters = GMNamedCurves.getByOID((ASN1ObjectIdentifier)sm2p256v1);
        ECNamedDomainParameters namedDomainParameters = new ECNamedDomainParameters(sm2p256v1, parameters.getCurve(), parameters.getG(), parameters.getN());
        ECPoint pukPoint = parameters.getCurve().decodePoint(publicKey);
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, (ECDomainParameters)namedDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(mode);
        SecureRandom secureRandom = new SecureRandom();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, secureRandom));
        byte[] encrypt = sm2Engine.processBlock(data, 0, data.length);
        return encrypt;
    }

    public static String encryptHex(String publicKey, String data) {
        return SM2Utils.encryptHex(publicKey, data, SM2Engine.Mode.C1C3C2);
    }

    public static String encryptHex(String publicKey, String data, SM2Engine.Mode mode) {
        byte[] key = Hex.decode((String)publicKey);
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] encrypt = SM2Utils.encrypt(key, bytes, mode);
        return Hex.toHexString((byte[])encrypt);
    }

    public static String encryptBase64(String publicKey, String data) {
        return SM2Utils.encryptBase64(publicKey, data, SM2Engine.Mode.C1C3C2);
    }

    public static String encryptBase64(String publicKey, String data, SM2Engine.Mode mode) {
        byte[] key = BASE64_DECODER.decode(publicKey);
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] encrypt = SM2Utils.encrypt(key, bytes, mode);
        return BASE64_ENCODER.encodeToString(encrypt);
    }

    public static byte[] decrypt(BigInteger privateKey, byte[] cipherData) {
        return SM2Utils.decrypt(privateKey, cipherData, SM2Engine.Mode.C1C3C2);
    }

    public static byte[] decrypt(BigInteger privateKey, byte[] cipherData, SM2Engine.Mode mode) {
        ASN1ObjectIdentifier sm2p256v1 = GMObjectIdentifiers.sm2p256v1;
        X9ECParameters parameters = GMNamedCurves.getByOID((ASN1ObjectIdentifier)sm2p256v1);
        ECNamedDomainParameters namedDomainParameters = new ECNamedDomainParameters(sm2p256v1, parameters.getCurve(), parameters.getG(), parameters.getN());
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKey, (ECDomainParameters)namedDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(mode);
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        if (cipherData[0] == 4) {
            return sm2Engine.processBlock(cipherData, 0, cipherData.length);
        }
        byte[] bytes = new byte[cipherData.length + 1];
        bytes[0] = 4;
        System.arraycopy(cipherData, 0, bytes, 1, cipherData.length);
        return sm2Engine.processBlock(bytes, 0, bytes.length);
    }

    public static String decryptHex(String privateKey, String cipherData) {
        return SM2Utils.decryptHex(privateKey, cipherData, SM2Engine.Mode.C1C3C2);
    }

    public static String decryptHex(String privateKey, String cipherData, SM2Engine.Mode mode) {
        BigInteger key = new BigInteger(privateKey, 16);
        byte[] decrypt = SM2Utils.decrypt(key, Hex.decode((String)cipherData), mode);
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    public static String decryptBase64(String privateKey, String cipherData) {
        return SM2Utils.decryptBase64(privateKey, cipherData, SM2Engine.Mode.C1C3C2);
    }

    public static String decryptBase64(String privateKey, String cipherData, SM2Engine.Mode mode) {
        BigInteger key = new BigInteger(BASE64_DECODER.decode(privateKey));
        byte[] decrypt = SM2Utils.decrypt(key, BASE64_DECODER.decode(cipherData), mode);
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    public static String sign(String plainText, BigInteger privateKey) throws GeneralSecurityException {
        X9ECParameters parameters = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        ECParameterSpec parameterSpec = new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN());
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(privateKey, parameterSpec);
        BCECPrivateKey bcecPrivateKey = new BCECPrivateKey(EC, privateKeySpec, BouncyCastleProvider.CONFIGURATION);
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)PROVIDER);
        signature.initSign((PrivateKey)bcecPrivateKey);
        signature.update(plainText.getBytes(StandardCharsets.UTF_8));
        return BASE64_ENCODER.encodeToString(signature.sign());
    }

    public static boolean verify(String plainText, String signText, byte[] publicKey) throws GeneralSecurityException {
        X9ECParameters parameters = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        ECParameterSpec parameterSpec = new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN());
        ECPoint ecPoint = parameters.getCurve().decodePoint(publicKey);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(ecPoint, parameterSpec);
        BCECPublicKey bcecPublicKey = new BCECPublicKey(EC, publicKeySpec, BouncyCastleProvider.CONFIGURATION);
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)PROVIDER);
        signature.initVerify((PublicKey)bcecPublicKey);
        signature.update(plainText.getBytes(StandardCharsets.UTF_8));
        return signature.verify(BASE64_DECODER.decode(signText));
    }

    public static boolean certVerify(String certText, String plainText, String signText) throws GeneralSecurityException {
        CertificateFactory factory = new CertificateFactory();
        X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(BASE64_DECODER.decode(certText)));
        Signature signature = Signature.getInstance(certificate.getSigAlgName(), (Provider)PROVIDER);
        signature.initVerify(certificate);
        signature.update(plainText.getBytes(StandardCharsets.UTF_8));
        return signature.verify(BASE64_DECODER.decode(signText));
    }

    public static void main(String[] args) {
        String plainText = "123456";
        SM2KeyPair<String, String> keys = SM2Utils.genKeyPairAsBase64();
        log.debug("\n\u516c\u94a5 : {}\n\u79c1\u94a5 : {}", (Object)keys.getPublic(), (Object)keys.getPrivate());
        String pubKey = "046e0df2c1cf15f57f59dc3ee13aecc6d25efc4bacb2e503423b2119b60ce79a2b6bf57eca1bc76df9446f2b63ee56c2f8eb8e8dd7e072a6db037a5d8d66623f48";
        String priKey = "f2ad7ce861f362caf026725b3e9558c5477e7e0f55a476b1a2200d43425a0e1b";
        String encrypt = SM2Utils.encryptBase64(pubKey, "123456");
        String decrypt = SM2Utils.decryptBase64(priKey, encrypt);
        log.debug("\n\u52a0\u5bc6 : {}\n\u89e3\u5bc6 : {}", (Object)encrypt, (Object)decrypt);
        try {
            String sign = SM2Utils.sign("123456", new BigInteger(BASE64_DECODER.decode(priKey)));
            boolean verify = SM2Utils.verify("123456", sign, BASE64_DECODER.decode(pubKey));
            log.debug("\n\u7b7e\u540d : {}\n\u9a8c\u7b7e : {}", (Object)sign, (Object)verify);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Objects.isNull(Security.getProvider("BC"))) {
            Security.addProvider((Provider)PROVIDER);
        }
    }
}

