/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.util;

import com.fshows.util.fnefpay.util.BaseHttpSSLSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClient {
    private static Logger log = LoggerFactory.getLogger(HttpClient.class);
    private URL url;
    private int connectionTimeout = 10000;
    private int readTimeOut = 30000;
    private String result;

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public HttpClient(String url, int connectionTimeout, int readTimeOut) throws Exception {
        try {
            this.url = new URL(url);
            this.connectionTimeout = connectionTimeout;
            this.readTimeOut = readTimeOut;
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception("\u975e\u6cd5URL," + e.getMessage());
        }
    }

    public int send(String data, String encoding) throws Exception {
        HttpURLConnection httpURLConnection = this.createConnection(encoding);
        if (null == httpURLConnection) {
            throw new Exception("\u521b\u5efa\u8054\u63a5\u5931\u8d25");
        }
        String sendData = data;
        log.info("\u8bf7\u6c42\u62a5\u6587:[{}]", (Object)sendData);
        this.requestServer(httpURLConnection, sendData, encoding);
        this.result = this.response(httpURLConnection, encoding);
        log.info("\u540c\u6b65\u8fd4\u56de\u62a5\u6587:[{}]", (Object)this.result);
        return httpURLConnection.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendGet(String encoding) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.createConnectionGet(encoding);
            if (null == httpURLConnection) {
                throw new Exception("\u521b\u5efa\u8054\u63a5\u5931\u8d25");
            }
            this.result = this.response(httpURLConnection, encoding);
            log.info("\u540c\u6b65\u8fd4\u56de\u62a5\u6587:[{}]", (Object)this.result);
            int n = httpURLConnection.getResponseCode();
            return n;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private void requestServer(URLConnection connection, String message, String encoder) throws IOException {
        connection.connect();
        try (PrintStream out = new PrintStream(connection.getOutputStream(), false, encoder);){
            out.print(message);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String response(HttpURLConnection connection, String encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            InputStream in;
            if (200 == connection.getResponseCode()) {
                in = connection.getInputStream();
                Throwable throwable = null;
                try {
                    sb.append(new String(HttpClient.read(in), encoding));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            in = connection.getErrorStream();
            Throwable throwable = null;
            try {
                sb.append(new String(HttpClient.read(in), encoding));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            log.info("HTTP Return Status-Code:[{}]", (Object)connection.getResponseCode());
            String string = sb.toString();
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    public static byte[] read(InputStream in) throws IOException {
        byte[] buf = new byte[1024];
        int length = 0;
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            while ((length = in.read(buf, 0, buf.length)) > 0) {
                bout.write(buf, 0, length);
            }
            bout.flush();
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
    }

    private HttpURLConnection createConnection(String encoding) throws ProtocolException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        httpURLConnection.setConnectTimeout(this.connectionTimeout);
        httpURLConnection.setReadTimeout(this.readTimeOut);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-type", "application/json;charset=" + encoding);
        httpURLConnection.setRequestMethod("POST");
        if ("https".equalsIgnoreCase(this.url.getProtocol())) {
            HttpsURLConnection husn = (HttpsURLConnection)httpURLConnection;
            husn.setSSLSocketFactory(new BaseHttpSSLSocketFactory());
            husn.setHostnameVerifier(new BaseHttpSSLSocketFactory.TrustAnyHostnameVerifier());
            return husn;
        }
        return httpURLConnection;
    }

    private HttpURLConnection createConnectionGet(String encoding) throws ProtocolException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        httpURLConnection.setConnectTimeout(this.connectionTimeout);
        httpURLConnection.setReadTimeout(this.readTimeOut);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=" + encoding);
        httpURLConnection.setRequestMethod("GET");
        if ("https".equalsIgnoreCase(this.url.getProtocol())) {
            HttpsURLConnection husn = (HttpsURLConnection)httpURLConnection;
            husn.setSSLSocketFactory(new BaseHttpSSLSocketFactory());
            husn.setHostnameVerifier(new BaseHttpSSLSocketFactory.TrustAnyHostnameVerifier());
            return husn;
        }
        return httpURLConnection;
    }
}

