/*
 * Decompiled with CFR 0.152.
 */
package com.fshows;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.digest.SM3;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSONObject;
import com.fshows.apienum.FjnxApiDefinitionEnum;
import com.fshows.component.FjnxClientConfigModel;
import com.fshows.component.Sm3ApiSignHandler;
import com.fshows.request.FjnxBaseRequest;
import com.fshows.request.FjnxBizRequest;
import com.fshows.request.FjnxHeadRequest;
import com.fshows.response.FjnxBaseResponse;
import com.fshows.response.FjnxBizResponse;
import com.fshows.response.FjnxHeadResponse;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import com.fshows.util.SMSaltSigner;
import com.fshows.util.fjnx.SecurityTools;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FjnxPayApiClinet
extends AbstractApiClient<FjnxBizRequest, FjnxBaseResponse, FjnxApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(FjnxPayApiClinet.class);
    protected IApiSignHandler iApiSignHandler = new Sm3ApiSignHandler();
    private SMSaltSigner signer = new SMSaltSigner();
    private SecurityTools securityTools;
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public FjnxPayApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        try {
            this.securityTools = new SecurityTools(apiClientConfig.getFubeiPrivateKey(), apiClientConfig.getPassword(), apiClientConfig.getPayCompanyPublicKey());
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"FjnxPayApiClinet >> \u798f\u5efa\u519c\u5546\u94f6\u884c\u516c\u79c1\u94a5\u52a0\u8f7d\u5931\u8d25! ", (Throwable)e);
            throw new FsApiException("\u52a0\u8f7d\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public FjnxBaseResponse execute(FjnxBizRequest request, FjnxApiDefinitionEnum apiDefinition) throws FsApiException {
        return (FjnxBaseResponse)this.doExecute(request, apiDefinition);
    }

    public FjnxBaseResponse execute(FjnxBizRequest request, FjnxApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected FjnxBaseResponse doExecute(FjnxBizRequest request, FjnxApiDefinitionEnum iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            FjnxBaseResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getRequest()), JSONObject.toJSONString((Object)apiResponseModel.getResponse()), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38[\u660e\u6587] >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(FjnxApiDefinitionEnum tradeApiDefinitionEnum, FjnxBizRequest request, DefaultClientConfigModel merchantConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        FjnxClientConfigModel clientConfig = (FjnxClientConfigModel)this.apiClientConfig;
        FjnxClientConfigModel config = this.newFjnxClientConfigModel(clientConfig);
        if (merchantConfig != null) {
            config.setAgentId(StringUtils.isEmpty((CharSequence)merchantConfig.getAgentId()) ? clientConfig.getAgentId() : merchantConfig.getAgentId());
            config.setAppId(StringUtils.isEmpty((CharSequence)merchantConfig.getAppId()) ? clientConfig.getAppId() : merchantConfig.getAppId());
            config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)merchantConfig.getFubeiPrivateKey()) ? clientConfig.getFubeiPrivateKey() : merchantConfig.getFubeiPrivateKey());
            config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)merchantConfig.getPayCompanyPublicKey()) ? clientConfig.getPayCompanyPublicKey() : merchantConfig.getPayCompanyPublicKey());
            config.setMd5SignKey(merchantConfig.getMd5SignKey());
            config.setSm4Key(((FjnxClientConfigModel)merchantConfig).getSm4Key());
        }
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    private FjnxClientConfigModel newFjnxClientConfigModel(FjnxClientConfigModel clientConfigModel) {
        FjnxClientConfigModel configModel = new FjnxClientConfigModel();
        configModel.setAppId(clientConfigModel.getAppId());
        configModel.setAgentId(clientConfigModel.getAgentId());
        configModel.setFubeiPrivateKey(clientConfigModel.getFubeiPrivateKey());
        configModel.setPayCompanyPublicKey(clientConfigModel.getPayCompanyPublicKey());
        configModel.setPassword(clientConfigModel.getPassword());
        configModel.setApiParentURL(clientConfigModel.getApiParentURL());
        configModel.setMd5SignKey(clientConfigModel.getMd5SignKey());
        configModel.setSignTypeEnum(clientConfigModel.getSignTypeEnum());
        configModel.setVrifySignResponse(clientConfigModel.isVrifySignResponse());
        configModel.setCheckParam(clientConfigModel.isCheckParam());
        configModel.setConnectionTimeout(clientConfigModel.getConnectionTimeout());
        configModel.setReadTimeout(clientConfigModel.getReadTimeout());
        configModel.setCharset(clientConfigModel.getCharset());
        configModel.setHump(clientConfigModel.isHump());
        configModel.setExtendParam(new HashMap(clientConfigModel.getExtendParam()));
        configModel.setSingIgnoreNull(clientConfigModel.isSingIgnoreNull());
        return configModel;
    }

    protected ApiRequestModel buildApiRequestModel(FjnxBizRequest request, DefaultRequestContext context) {
        FjnxClientConfigModel configModel = (FjnxClientConfigModel)context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json;charset=utf-8");
        headerMap.put("Accept", "application/json");
        headerMap.put("Accept-Encoding", "identity");
        apiRequestModel.setHeadMap(headerMap);
        request.setApplication(configModel.getAgentId());
        Date now = new Date();
        request.setTradeDate(DateUtil.format((Date)now, (String)"yyyyMMdd"));
        request.setTradeTime(DateUtil.format((Date)now, (String)"HHmmss"));
        request.setVersion("1.0");
        String randomSecretKey = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        String digitalEnvelope = this.securityTools.digitalEnvelope(randomSecretKey);
        String plaintext = JSONObject.toJSONString((Object)request);
        String digest = SM3.create().digestHex(plaintext).toUpperCase();
        String signature = this.securityTools.sign(digest);
        FjnxHeadRequest headRequest = new FjnxHeadRequest();
        headRequest.setMerInstId(configModel.getAppId());
        headRequest.setSysInstId("S000000002");
        headRequest.setDigitalEnvelope(digitalEnvelope);
        headRequest.setSignature(signature);
        headRequest.setSignType("03");
        String ciphertext = new SM4(HexUtil.decodeHex((String)randomSecretKey)).encryptHex(plaintext).toUpperCase();
        JSONObject requestJson = new JSONObject();
        requestJson.put("head", (Object)headRequest);
        requestJson.put("body", (Object)ciphertext);
        apiRequestModel.setRequestBody(requestJson.toJSONString());
        apiRequestModel.setRequest((IRequestDefinition)new FjnxBaseRequest(headRequest, request));
        return apiRequestModel;
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u798f\u5efa\u519c\u4fe1");
        clientInfoModel.setClientCode("fjnxpay-sdk");
        return clientInfoModel;
    }

    protected FjnxBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        FjnxClientConfigModel clientConfigModel = (FjnxClientConfigModel)requestContext.getApiClientConfig();
        JSONObject resJson = JSONObject.parseObject((String)apiResponseModel.getResponseBody());
        String encryptedBody = (String)resJson.remove((Object)"body");
        FjnxBaseResponse response = (FjnxBaseResponse)resJson.toJavaObject(FjnxBaseResponse.class);
        if (StringUtils.isBlank((CharSequence)encryptedBody)) {
            return response;
        }
        FjnxHeadResponse headResponse = response.getHead();
        String secretKey = this.securityTools.decryptDigitalEnvelope(headResponse.getDigitalEnvelope());
        System.out.println("\u89e3\u5bc6\u79d8\u94a5\uff1a" + secretKey);
        String decryptedBody = new SM4(HexUtil.decodeHex((String)secretKey)).decryptStr(encryptedBody);
        System.out.println("\u89e3\u5bc6\u660e\u6587: " + decryptedBody);
        FjnxBizResponse fjnxBizResponse = (FjnxBizResponse)JSONObject.parseObject((String)decryptedBody, (Class)requestContext.getIApiDefinition().getResponseClass());
        response.setBody(fjnxBizResponse);
        apiResponseModel.setResponse((IResponseDefinition)response);
        String digest = SM3.create().digestHex(decryptedBody).toUpperCase();
        Boolean verifySign = this.securityTools.verify(headResponse.getSignature(), digest);
        if (clientConfigModel.isVrifySignResponse() && !Boolean.TRUE.equals(verifySign)) {
            throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25");
        }
        return response;
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }
}

