/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.gm;

import com.fshows.util.fnefpay.gm.CertUtils_SM2;
import com.fshows.util.fnefpay.gm.SM2;
import com.fshows.util.fnefpay.gm.SM2_Result;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import shaded.org.bouncycastle.math.ec.ECPoint;
import shaded.org.bouncycastle.util.encoders.Hex;

public class SecureUtils_SM2 {
    public static String sign(String data, String encoding, String userId, BigInteger priKey) {
        SM2 sm2 = new SM2();
        SM2_Result sret = sm2.Sign(userId.getBytes(), data.getBytes(), priKey, null);
        return Hex.toHexString((byte[])sm2.BigIntegerToByteArray(sret.r)) + Hex.toHexString((byte[])sm2.BigIntegerToByteArray(sret.s));
    }

    public static boolean validate(String sign, String origData, String encoding, String certId) throws UnsupportedEncodingException {
        String pubKeystr = Hex.toHexString((byte[])CertUtils_SM2.getVryCert(certId).getPublicKey());
        SM2 sm2 = new SM2();
        String publicKeyXHex = pubKeystr.substring(0, pubKeystr.length() / 2);
        String publicKeyYHex = pubKeystr.substring(pubKeystr.length() / 2);
        ECPoint PA = sm2.GetPoint(new BigInteger(publicKeyXHex, 16), new BigInteger(publicKeyYHex, 16));
        String signRHex = sign.substring(0, sign.length() / 2);
        String signSHex = sign.substring(sign.length() / 2);
        Boolean result = sm2.Verify(origData.getBytes(encoding), certId.getBytes(encoding), PA, new BigInteger(signRHex, 16), new BigInteger(signSHex, 16));
        return result;
    }
}

