/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util;

import com.fshows.util.SM2KeyPair;
import com.fshows.util.Utils;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.crypto.generators.KDF1BytesGenerator;
import org.bouncycastle.crypto.params.ISO18033KDFParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util {
    private static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static final BigInteger xg = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger yg = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static SecureRandom random = new SecureRandom();
    private ECCurve.Fp curve = new ECCurve.Fp(p, a, b, null, null);
    private ECPoint G = this.curve.createPoint(xg, yg);

    public BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    public byte[] encrypt(String input, String publicKey) {
        ECPoint publicKeyECPoint = this.curve.decodePoint(Utils.hexToByte(publicKey));
        return this.encrypt(input, publicKeyECPoint);
    }

    public byte[] encrypt(String input, ECPoint publicKey) {
        byte[] inputBuffer = input.getBytes();
        BigInteger k = this.random(n);
        ECPoint C1 = this.G.multiply(k);
        byte[] C1Buffer = C1.getEncoded(false);
        ECPoint kpb = publicKey.multiply(k).normalize();
        byte[] kpbBytes = kpb.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        byte[] t = new byte[inputBuffer.length];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(kpbBytes));
        kdf.generateBytes(t, 0, t.length);
        if (this.allZero(t)) {
            throw new RuntimeException("all zero");
        }
        byte[] C2 = new byte[inputBuffer.length];
        for (int i = 0; i < inputBuffer.length; ++i) {
            C2[i] = (byte)(inputBuffer[i] ^ t[i]);
        }
        byte[] C3 = this.calculateHash(kpb.getXCoord().toBigInteger(), inputBuffer, kpb.getYCoord().toBigInteger());
        byte[] encryptResult = new byte[C1Buffer.length + C2.length + C3.length];
        System.arraycopy(C1Buffer, 0, encryptResult, 0, C1Buffer.length);
        System.arraycopy(C2, 0, encryptResult, C1Buffer.length, C2.length);
        System.arraycopy(C3, 0, encryptResult, C1Buffer.length + C2.length, C3.length);
        return encryptResult;
    }

    public String decrypt(byte[] encryptData, String privateKey) {
        byte[] bb = Utils.hexToByte(privateKey);
        BigInteger userD = new BigInteger(1, bb);
        return this.decrypt(encryptData, userD);
    }

    public String decrypt(byte[] encryptData, BigInteger privateKey) {
        byte[] C1Byte = new byte[65];
        System.arraycopy(encryptData, 0, C1Byte, 0, C1Byte.length);
        ECPoint C1 = this.curve.decodePoint(C1Byte).normalize();
        ECPoint dBC1 = C1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        int klen = encryptData.length - 65 - 20;
        byte[] t = new byte[klen];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(dBC1Bytes));
        kdf.generateBytes(t, 0, t.length);
        if (this.allZero(t)) {
            throw new RuntimeException("all zero");
        }
        byte[] M = new byte[klen];
        for (int i = 0; i < M.length; ++i) {
            M[i] = (byte)(encryptData[C1Byte.length + i] ^ t[i]);
        }
        byte[] C3 = new byte[20];
        System.arraycopy(encryptData, encryptData.length - 20, C3, 0, 20);
        byte[] u = this.calculateHash(dBC1.getXCoord().toBigInteger(), M, dBC1.getYCoord().toBigInteger());
        if (Arrays.equals(u, C3)) {
            return new String(M);
        }
        throw new RuntimeException("\u89e3\u5bc6\u9a8c\u8bc1\u5931\u8d25");
    }

    private byte[] calculateHash(BigInteger x2, byte[] M, BigInteger y2) {
        ShortenedDigest digest = new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20);
        byte[] buf = x2.toByteArray();
        digest.update(buf, 0, buf.length);
        digest.update(M, 0, M.length);
        buf = y2.toByteArray();
        digest.update(buf, 0, buf.length);
        buf = new byte[20];
        digest.doFinal(buf, 0);
        return buf;
    }

    private boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (this.between(x, new BigInteger("0"), p) && this.between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                BigInteger yResult = y.pow(2).mod(p);
                if (yResult.equals(xResult) && publicKey.multiply(n).isInfinity()) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public SM2KeyPair generateKeyPair() {
        BigInteger d = this.random(n.subtract(new BigInteger("1")));
        SM2KeyPair keyPair = new SM2KeyPair(this.G.multiply(d).normalize(), d);
        if (this.checkPublicKey(keyPair.getPublicKey())) {
            return keyPair;
        }
        throw new RuntimeException("generate key failed");
    }

    public static void main(String[] args) {
        String M = "ererfeiisgod";
        SM2Util sm2 = new SM2Util();
        String publicKey = "6e0df2c1cf15f57f59dc3ee13aecc6d25efc4bacb2e503423b2119b60ce79a2b6bf57eca1bc76df9446f2b63ee56c2f8eb8e8dd7e072a6db037a5d8d66623f48";
        String privateKey = "00985451BB1B015AF1AC5C14614A2DEB9CB39B6B392070E3DAFEADA417CC481FA9";
        ECPoint publicKeyECPoint = sm2.curve.decodePoint(Utils.hexToByte(publicKey));
        BigInteger userD = new BigInteger(1, Utils.hexToByte(privateKey));
        byte[] data = sm2.encrypt(M, publicKeyECPoint);
        System.out.println("\u52a0\u5bc6:" + Utils.byteToHex(data));
        String deData = sm2.decrypt(data, userD);
        System.out.println("\u89e3\u5bc6:" + deData);
    }
}

