/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fnefpay.sdk;

import com.fshows.util.fnefpay.gj.CertUtils_RSA;
import com.fshows.util.fnefpay.gj.MACUtils;
import com.fshows.util.fnefpay.gj.SecureUtils_RSA;
import com.fshows.util.fnefpay.gm.SecureUtils_SM2;
import com.fshows.util.fnefpay.sdk.FnefPayConfig;
import com.fshows.util.fnefpay.util.Base64Utils;
import com.fshows.util.fnefpay.util.ByteUtils;
import com.fshows.util.fnefpay.util.PropertyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.bouncycastle.util.encoders.Hex;

public class FnefPayUtils {
    public static boolean validate(Map<String, Object> reqData, Map<String, Object> resData, String encoding, String signMethod) throws Exception {
        if (FnefPayUtils.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if (FnefPayUtils.isEmpty(signMethod)) {
            signMethod = "01";
        }
        String stringSign = (String)resData.get("Signature");
        String stringData = (String)resData.get("Plain");
        if ("01".equals(signMethod)) {
            String certId = FnefPayConfig.getConfig().getValidateCertSn();
            return SecureUtils_RSA.validateSignBySoft(CertUtils_RSA.getValidatePublicKey(certId), Base64Utils.base64Decode(stringSign.getBytes(encoding)), stringData.getBytes(encoding));
        }
        if ("21".equals(signMethod)) {
            String certId = FnefPayConfig.getConfig().getGmValidateCertSn();
            String hexSign = Hex.toHexString((byte[])Base64Utils.base64Decode(stringSign.getBytes(encoding)));
            return SecureUtils_SM2.validate(hexSign, stringData, encoding, certId);
        }
        if ("20".equals(signMethod)) {
            String termId = (String)reqData.get("TerminalId");
            PropertyUtils propertyUtil = new PropertyUtils();
            String macKey = propertyUtil.getKeyValue("TERMKEY." + termId + "TERMKEY.");
            if (FnefPayUtils.isEmpty(macKey)) {
                return false;
            }
            byte[] byteData = SecureUtils_RSA.sha256(stringData, "UTF-8");
            byte[] byteBsData = Base64Utils.base64Encode(byteData);
            byte[] byteMac = MACUtils.calculateANSIX9_9MAC(ByteUtils.hexStringToBytes(macKey), byteBsData);
            if (stringSign.equals(ByteUtils.getHexString(byteMac).toUpperCase())) {
                return true;
            }
        }
        return false;
    }

    public static String getMessage(String result) {
        Pattern p = Pattern.compile("<Message>(.*?)</Message>", 34);
        Matcher m = p.matcher(result);
        String retStr = null;
        while (m.find()) {
            retStr = m.group(1);
        }
        return retStr;
    }

    public static String getSignature(String result) {
        Pattern p = Pattern.compile("<Signature>(.*?)</Signature>");
        Matcher m = p.matcher(result);
        String retStr = null;
        while (m.find()) {
            retStr = m.group(1);
        }
        return retStr;
    }

    public static Map<String, Object> filterBlank(Map<String, Object> contentData) {
        HashMap<String, Object> submitFromData = new HashMap<String, Object>();
        Set<String> keyset = contentData.keySet();
        for (String key : keyset) {
            Object value = contentData.get(key);
            if (value instanceof ArrayList) {
                if (value == null || ((ArrayList)value).size() == 0) continue;
                submitFromData.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                if (value == null || ((Map)value).size() == 0) continue;
                submitFromData.put(key, value);
                continue;
            }
            if (value == null || "".equals(String.valueOf(value).trim())) continue;
            submitFromData.put(key, String.valueOf(value).trim());
        }
        return submitFromData;
    }

    public static void printMap(Map<String, Object> contentData) {
        Set<String> keyset = contentData.keySet();
        for (String key : keyset) {
            Object value = contentData.get(key);
            if (value instanceof Map) {
                FnefPayUtils.printMap((Map)value);
                continue;
            }
            if (value != null && "".equals(((String)value).trim())) continue;
        }
    }

    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }
}

