/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util.fjnx;

import com.fshows.util.fnefpay.gm.PKCS12_SM2;
import com.fshows.util.fnefpay.gm.X509Cert_SM2;
import java.math.BigInteger;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Sequence;
import shaded.org.bouncycastle.util.encoders.Base64;
import shaded.org.bouncycastle.util.encoders.Hex;

public class Sm2Cert2HexUtil {
    public static String cert2HexPublicKey(String certPublicKey) throws Exception {
        if (null == certPublicKey || certPublicKey.trim().length() == 0) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u7a7a");
        }
        X509Cert_SM2 certSm2 = new X509Cert_SM2(certPublicKey.getBytes());
        return Hex.toHexString((byte[])certSm2.getPublicKey());
    }

    public static String cert2HexPrivateKey(String certPrivateKey, String certPassword) throws Exception {
        if (certPrivateKey == null) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u7a7a");
        }
        if (certPassword == null) {
            throw new IllegalArgumentException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ASN1Sequence privateASN1Sequence = ASN1Sequence.getInstance((Object)Base64.decode((String)certPrivateKey));
        if (privateASN1Sequence == null || privateASN1Sequence.size() != 3) {
            throw new Exception("invalid SM2File encoding");
        }
        ASN1Sequence privateInfo = (ASN1Sequence)privateASN1Sequence.getObjectAt(1);
        ASN1Sequence publicInfo = (ASN1Sequence)privateASN1Sequence.getObjectAt(2);
        if (privateInfo.size() != 3) {
            throw new Exception("the sm2 file is not right format,can not get the private part");
        }
        if (publicInfo.size() != 2) {
            throw new Exception("the sm2 file is not right format.can not get the public part");
        }
        ASN1OctetString priOctString = (ASN1OctetString)privateInfo.getObjectAt(2);
        byte[] encryptedData = priOctString.getOctets();
        String dBytes = PKCS12_SM2.SM4DecryptDBytes(certPassword, encryptedData);
        BigInteger privateKey = new BigInteger(dBytes, 16);
        return privateKey.toString(16);
    }
}

