package com.fshows.util.fnefpay.util;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.digest.SM3;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSONObject;
import com.fshows.util.fjnx.SecurityTools;
import com.fshows.util.fnefpay.exception.TransException;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * 国密加密解密工具
 */
public class GmUtils {

    /**
     * 加密、加签
     *
     * @param head
     * @param body
     * @param privateKey
     * @param passWord   证书密码
     * @param publicKey
     * @return
     */
    public static String signAndEncrypt(Map<String, Object> head, Map<String, Object> body, String privateKey, String passWord, String publicKey) throws Exception {
        if (null == head) {
            throw new TransException("请求头不能为空");
        }
        if (null == body) {
            throw new TransException("请求内容不能为空");
        }
        String bodyString = JSONObject.toJSONString(body);

        // 通过明文 获取摘要
        String digest = SM3.create().digestHex(bodyString).toUpperCase();
        SecurityTools securityTools = new SecurityTools(privateKey, passWord, publicKey);
        String signature = securityTools.sign(digest);

        // 32位的随机对称秘钥C（且满足正则表达式^[A-Fa-f0-9]+$） 32 * 8
        String secretKey = UUID.randomUUID().toString().replace("-", "").toUpperCase();

        String encryptedBody = new SM4(HexUtil.decodeHex(secretKey)).encryptHex(bodyString).toUpperCase();

        String digitalEnvelope = securityTools.digitalEnvelope(secretKey);

        // 组装加密报文结构
        Map<String, Object> requestMap = new HashMap<>();

        Map<String, Object> headEncrypt = new HashMap<>();
        headEncrypt.put("merInstId", head.get("merInstId"));
        headEncrypt.put("sysInstId", head.get("sysInstId"));
        headEncrypt.put("digitalEnvelope", digitalEnvelope);
        headEncrypt.put("signature", signature);
        headEncrypt.put("signType", head.get("signType"));

        requestMap.put("head", headEncrypt);
        requestMap.put("body", encryptedBody);

        return JSONObject.toJSONString(requestMap);
    }

    /**
     * 解密、验签
     *
     * @param message    响应回来的信息
     * @param privateKey 私钥
     * @param password   证书密码
     * @param publicKey  公钥
     * @throws Exception
     */
    public static String verifyAndDecrypt(String message, String privateKey, String password, String publicKey) throws Exception {
        Map<String, Object> map = new HashMap<>();

        Map parseMap = JSONObject.parseObject(message, map.getClass());

        // 获取head和body信息
        Object head = parseMap.get("head");
        Object body = parseMap.get("body");
        Map headMap = JSONObject.parseObject(JSONObject.toJSONString(head), map.getClass());
        // 开始解密验签
        Object digitalEnvelope = headMap.get("digitalEnvelope");
        Object signature = headMap.get("signature");

        SecurityTools securityTools = new SecurityTools(privateKey, password, publicKey);
        String secretKey = securityTools.decryptDigitalEnvelope((String) digitalEnvelope);

        String decryptedBody = new SM4(HexUtil.decodeHex(secretKey)).decryptStr((String) body);

        // 通过明文 获取摘要
        String digest = SM3.create().digestHex(decryptedBody).toUpperCase();
        if (!securityTools.verify((String) signature, digest)) {
            throw new TransException("验签失败");
        }
        return decryptedBody;
    }


}
