package com.fshows.util.fnefpay.util;

/**
 * 字节工具类
 */
public class ByteUtils {
    /**
     * 右补字节至指定长度
     *
     * @param valueByte
     * @param length
     * @param padByte
     * @return
     */
    public static byte[] bytesPadRight(byte[] valueByte, int length, byte padByte) {
        int padLen = length - valueByte.length;
        byte[] rightByte = new byte[padLen];
        for (int i = 0; i < padLen; i = i + 1) {
            rightByte[i] = padByte;
        }

        return arrayApend(valueByte, rightByte);
    }

    /**
     * 左补字节至指定长度
     *
     * @param valueByte
     * @param length
     * @param padByte
     * @return
     */
    public static byte[] bytesPadLeft(byte[] valueByte, int length, byte padByte) {
        int padLen = length - valueByte.length;
        byte[] leftByte = new byte[padLen];
        for (int i = 0; i < padLen; i = i + 1) {
            leftByte[i] = padByte;
        }

        return arrayApend(leftByte, valueByte);
    }

    /**
     * 返回a和b的组合,实现累加功能
     *
     * @param a
     * @param b
     * @return
     */
    public static byte[] arrayApend(byte[] a, byte[] b) {
        int a_len = (a == null ? 0 : a.length);
        int b_len = (b == null ? 0 : b.length);
        byte[] c = new byte[a_len + b_len];
        if (a_len == 0 && b_len == 0) {
            return null;
        } else if (a_len == 0) {
            System.arraycopy(b, 0, c, 0, b.length);
        } else if (b_len == 0) {
            System.arraycopy(a, 0, c, 0, a.length);
        } else {
            System.arraycopy(a, 0, c, 0, a.length);
            System.arraycopy(b, 0, c, a.length, b.length);
        }

        return c;
    }

    /**
     * 获取子字节
     *
     * @param paramArrayOfByte
     * @param paramInt1
     * @param paramInt2
     * @return
     */
    public static byte[] getSubBytesByIndex(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        byte[] arrayOfByte = new byte[paramInt2];
        int i = 0;
        while (true) {
            if (i >= paramInt2)
                return arrayOfByte;
            arrayOfByte[i] = paramArrayOfByte[(i + paramInt1)];
            i += 1;
        }
    }

    public static String getEigthBitsStringFromByte(int b) {
        b |= 256; // mark the 9th digit as 1 to make sure the string
        String str = Integer.toBinaryString(b);
        int len = str.length();
        return str.substring(len - 8, len);
    }

    /**
     * 16进制字节数组转成二进制字符串
     *
     * @param b
     * @return
     */
    public static String getBinaryString(byte[] b) {
        String strsum = "";
        for (int i = 0; i < b.length; i++) {
            strsum += getEigthBitsStringFromByte(b[i]);
        }
        return strsum;
    }

    public static byte getByteFromEigthBitsString(String str) {
        byte b;
        if (str.substring(0, 1).equals("1")) {
            str = "0" + str.substring(1);
            b = Byte.valueOf(str, 2);
            b |= 128;
        } else {
            b = Byte.valueOf(str, 2);
        }
        return b;
    }

    /**
     * 二进制字符串转成16进制字节数组
     *
     * @param str
     * @return
     */
    public static byte[] binaryStringToBytes(String str) {
        String tmpstr;
        int j = 0;

        int num = (str.length() - 1) / 8;
        if ((str.length() - 1) % 8 != 0) {
            num = num + 1;
        }
        byte[] b = new byte[num];
        for (int i = 0; i < str.length(); i = i + 8) {
            tmpstr = str.substring(i, i + 8);
            b[j] = getByteFromEigthBitsString(tmpstr);
            j = j + 1;
        }
        return b;
    }

    /**
     * 字节数组转16进制字符串
     *
     * @param b
     * @return
     */
    public static String getHexString(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; n++) {
            stmp = (Integer.toHexString(b[n] & 0XFF));

            if (stmp.length() == 1) {
                hs = hs + "0" + stmp;
            } else {
                hs = hs + stmp;
            }
        }
        return hs;
    }

    /**
     * 16进制字符串转字节数组
     *
     * @param str
     * @return
     */
    public static byte[] hexStringToBytes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        int len = str.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < str.length(); i += 2) {
                b[i / 2] = (byte) Integer.decode("0x" + str.substring(i, i + 2)).intValue();
            }
            return b;
        } catch (Exception e) {
            return null;
        }
    }

    public static int bytesToInt(byte[] bRefArr) {
        int iOutcome = 0;
        byte bLoop;

        for (int i = 0; i < bRefArr.length; i++) {
            bLoop = bRefArr[i];
            iOutcome += (bLoop & 0xFF) << (8 * i);
        }
        return iOutcome;
    }

    public static byte[] intToBytes(int n) {
        byte[] b = new byte[4];
        int temp = n;
        for (int i = b.length - 1; i > -1; i--) {
            b[i] = new Integer(temp & 0xff).byteValue();
            temp = temp >> 8;
        }
        return b;
    }

    public static byte[] shortToBytes(short n) {
        byte[] b = new byte[2];
        b[1] = (byte) (n & 0xff);
        b[0] = (byte) ((n >> 8) & 0xff);
        return b;
    }

    public static short bytesToShort(byte[] bytesShort) {
        short sRet = 0;
        sRet += (bytesShort[0] & 0xFF) << 8;
        sRet += bytesShort[1] & 0xFF;
        return sRet;
    }

    public static byte[] bytesTrimLeft(byte[] trimBytes, byte trimByte) {
        int j = 0;
        for (int i = 0; i < trimBytes.length; i = i + 1) {
            if (trimBytes[i] != trimByte) {
                break;
            }
            j++;
        }
        return getSubBytesByIndex(trimBytes, j, trimBytes.length - j);
    }
}
