package com.fshows.util.fnefpay.gm;

import shaded.org.bouncycastle.math.ec.ECPoint;
import shaded.org.bouncycastle.util.encoders.Hex;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

/**
 * 国密安全算法工具类
 */
public class SecureUtils_SM2 {
    /**
     * SM2签名
     *
     * @param data     签名原串
     * @param encoding 编码
     * @param userId   用户标识（此处填写证书序列号）
     * @param priKey   私钥
     * @return 签名值
     */
    public static String sign(String data, String encoding, String userId, BigInteger priKey) {
        SM2 sm2 = new SM2();
        SM2_Result sret = sm2.Sign(userId.getBytes(), data.getBytes(), priKey, null);
        return Hex.toHexString(sm2.BigIntegerToByteArray(sret.r)) + Hex.toHexString(sm2.BigIntegerToByteArray(sret.s));
    }

    /**
     * SM2验签
     *
     * @param sign     hex签名值
     * @param origData 原始串
     * @param encoding 编码
     * @param certId   证书序列号
     * @return 验签结果
     * @throws UnsupportedEncodingException
     */
    public static boolean validate(String sign, String origData, String encoding, String certId) throws UnsupportedEncodingException {
        String pubKeystr = Hex.toHexString(CertUtils_SM2.getVryCert(certId).getPublicKey());
        SM2 sm2 = new SM2();
        String publicKeyXHex = pubKeystr.substring(0, pubKeystr.length() / 2);
        String publicKeyYHex = pubKeystr.substring(pubKeystr.length() / 2);
        ECPoint PA = sm2.GetPoint(new BigInteger(publicKeyXHex, 16), new BigInteger(publicKeyYHex, 16));
        String signRHex = sign.substring(0, sign.length() / 2);
        String signSHex = sign.substring(sign.length() / 2);
        Boolean result = sm2.Verify(origData.getBytes(encoding),
                certId.getBytes(encoding), PA, new BigInteger(signRHex, 16),
                new BigInteger(signSHex, 16));
        return result;
    }

}
