/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 微信公众号/小程序/APP支付下单接口 response
 *
 * @author
 * @version FjnxWxJsapiPayRes.java, v 0.1 2024-11-26 14:57:10
 */
@Data
public class FjnxWxJsapiPayRes extends FjnxBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555848505993L;


    /**
     * 商户编号，最大长度为15
     * (必填)
     */
    @NotBlank
    private String mchtNo;

    /**
     * 交易金额，单位为元，精确到小数点后两位，带小数点，最大长度为12
     * (必填)
     */
    @NotBlank
    private String txnAmt;

    /**
     * 支付信息，包含支付详情字段，如appId、timeStamp、nonceStr等
     * (选填)
     */
    private FjnxPayInfoRes payInfo;

    /**
     * 微信支付数据，最大长度为1024
     * (选填)
     */
    private String wcPayData;

    /**
     * 预支付回话标识，用于后续接口调用中使用，最大长度为64
     * (选填)
     */
    private String prepayId;

}