/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 福建农商银行SDK请求头
 *
 * @author liluqing
 * @version FjnxHeadRequest.java, v 0.1 2024-11-21 下午3:48
 */
@Data
public class FjnxHeadResponse implements Serializable {

    /**
     * 商户编号
     */
    private String merInstId;

    /**
     * 终端编号
     */
    private String terminalId;

    /**
     * 数字信封
     * 每次交易生成sm4对称密钥然后使用磁道密钥对对称密钥加密得到
     */
    private String digitalEnvelope;

    /**
     * 签名
     * 使用sm3算法对源报文体进行摘要，然后使用mac密钥对摘要进行加密得到
     */
    private String signature;

    /**
     * 算法类型
     * 03-sm2 国密算法
     * 05-mac版
     * 为空或者其他值均默认为sm4
     */
    private String signType;

    /**
     * 业务状态
     * FAIL--交易失败
     * INIT--初始化
     * PROCESSING--处理中
     * SUCCESS--交易成功
     * UNKNOWN--交易超时
     * CLOSED--已关单
     */
    private String status;

    /**
     * 平台返回码
     * 0000--处理成功
     * 000000--处理成功
     * 0001--权限不足
     * 1004--验签失败
     * 2000--交易失败
     * 2001--交易处理中
     * 2002--交易结果未知
     * 9003--请求参数错误
     * 9005--内部系统通讯异常(超时)
     * 9999-系统异常
     */
    private String retCode;

    /**
     * 平台返回信息
     */
    private String retMsg;
}