/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 通过授权码获取用户开放标识 request
 *
 * @author
 * @version FjnxUnionUserIdReq.java, v 0.1 2024-11-26 15:36:38
 */
@Data
public class FjnxUnionUserIdReq extends FjnxBizRequest implements Serializable {

    private static final long serialVersionUID = -2213838555456754977L;


    /**
     * 用户授权码，通过请求的Http中的User Agent截取，格式为“UnionPay /<版本号> <App标识>”，从前往后截取，匹配“UnionPay /”作为开始，至英文空格之间的内容为版本号，从英文空格开始，至非字母非数字结束，之间的内容为App标识
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "userAhrCd长度不能超过64")
    private String userAhrCd;

    /**
     * 银联支付标识
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "appUpIdentifier长度不能超过64")
    private String appUpIdentifier;

}