/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 * @author liluqing
 * @version FjnxTermInfoReq.java, v 0.1 2024-11-26 下午2:43
 */
@Data
public class FjnxTermInfoReq implements Serializable {

    private static final long serialVersionUID = 1766470814414309205L;


    /**
     * 经度信息，+表示北纬、东经，-表示南纬、西经
     * (选填)
     */
    @Length(max = 10, message = "longitude长度不能超过10")
    private String longitude;

    /**
     * 纬度信息，+表示北纬、东经，-表示南纬、西经
     * (选填)
     */
    @Length(max = 10, message = "latitude长度不能超过10")
    private String latitude;

    /**
     * 终端入网认证编号，银行卡受理终端产品入网认证编号
     * (选填)
     */
    @Length(max = 5, message = "networkLicense长度不能超过5")
    private String networkLicense;

    /**
     * 设备类型，01--自动柜员机，02--传统 POS，03--mPOS，04--智能 POS
     * (选填)
     */
    @Length(max = 2, message = "deviceType长度不能超过2")
    private String deviceType;

    /**
     * 终端设备的硬件序列号，终端类型为 02、03、04、05、06、08、09 或 10时，必须填写终端序列号
     * (选填)
     */
    @Length(max = 50, message = "serialNum长度不能超过50")
    private String serialNum;

    /**
     * 仅在被扫支付类交易报文中出现：若付款码为 19 位数字，则取后 6 位；若付款码为 EMV 二维码，则取其tag 57 的卡号/token 号的后 6 位
     * (选填)
     */
    @Length(max = 10, message = "encryptRandNum长度不能超过10")
    private String encryptRandNum;

    /**
     * 仅在被扫支付类交易报文中出现：64bit的密文数据，8-16位变长
     * (选填)
     */
    @Length(max = 16, message = "secretText长度不能超过16")
    private String secretText;

    /**
     * 终端应用程序的版本号，应用程序变更应保证版本号不重复
     * (选填)
     */
    @Length(max = 8, message = "appVersion长度不能超过8")
    private String appVersion;

    /**
     * 商户端设备IP，与TerminalIp要保持一致。注：如经、纬度信息未上送，该字段必送
     * (选填)
     */
    @Length(max = 64, message = "deviceIp长度不能超过64")
    private String deviceIp;
}