/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 被扫支付接口 request
 *
 * @author
 * @version FjnxScanOrderCreateReq.java, v 0.1 2024-11-26 14:37:48
 */
@Data
public class FjnxScanOrderCreateReq extends FjnxBizRequest {

    private static final long serialVersionUID = -2213838555461332617L;

    /**
     * 支付场景，WEB--网上商城, H5--页面收银台, APPLETS--商家小程序, OFFICIAL--商家公众号, POS--pos终端, APP--商户APP, OTHER--其他场景
     * (选填)
     */
    @Length(max = 8, message = "payScene长度不能超过8")
    private String payScene;

    /**
     * 交易金额，单位为元，精确到小数点后两位，带小数点
     * (选填)
     */
    @Length(max = 12, message = "txnAmt长度不能超过12")
    private String txnAmt;

    /**
     * 业务类型，默认按付款码支付，MICROPAY--付款码支付, FACEPAY--刷脸支付
     * (选填)
     */
    @Length(max = 16, message = "tradeType长度不能超过16")
    private String tradeType;

    /**
     * 内部用户号，用于获取组合支付时核心客户号
     * (选填)
     */
    @Length(max = 25, message = "memberNo长度不能超过25")
    private String memberNo;

    /**
     * 支付方式，WX--微信, AL--支付宝, UN--银联二维码，刷脸支付时必传，付款码根据付款码匹配支付方式
     * (选填)
     */
    @Length(max = 16, message = "payType长度不能超过16")
    private String payType;

    /**
     * 消费支付账单的商品信息
     * (选填)
     */
    @Length(max = 128, message = "merchantOrderInfo长度不能超过128")
    private String merchantOrderInfo;

    /**
     * 商户订单信息详情
     * (选填)
     */
    private List<FjnxMerchantOrderInfoDtlReq> merchantOrderInfoDtl;


    /**
     * 备注，在对账单展示
     * (选填)
     */
    @Length(max = 128, message = "attach长度不能超过128")
    private String attach;

    /**
     * 扫码支付授权码，设备读取用户展示的条码或者二维码信息
     * (选填)
     */
    @Length(max = 18, message = "userAhrCd长度不能超过18")
    private String userAhrCd;

    /**
     * 服务商机构标识码
     * (选填)
     */
    @Length(max = 8, message = "serviceInstIdCode长度不能超过8")
    private String serviceInstIdCode;

    /**
     * 终端信息
     * (选填)
     */
    private List<FjnxTermInfoReq> termInfo;
}