/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 * @author liluqing
 * @version FjnxBizRequest.java, v 0.1 2024-11-21 下午3:53
 */
@Data
public class FjnxBizRequest implements IRequestDefinition {

    private static final long serialVersionUID = 7221327796066522380L;

    /**
     * 请求方流水号，接入渠道编号+商户自定义流水号，商户唯一
     * (必填)
     */
    @Length(max = 32, message = "tradeNo长度不能超过32")
    private String tradeNo;

    /**
     * 请求方交易日期，格式为YYYYMMDD
     * (必填)
     */
    @Length(max = 8, message = "tradeDate长度不能超过8")
    private String tradeDate;

    /**
     * 请求方交易时间，格式为HHMMSS
     * (必填)
     */
    @Length(max = 6, message = "tradeTime长度不能超过6")
    private String tradeTime;

    /**
     * 平台编号，由收银台分配的平台编号，平台接入时必输
     * (选填)
     */
    @Length(max = 32, message = "application长度不能超过32")
    private String application;

    /**
     * 商户号
     * (必填)
     */
    @Length(max = 15, message = "mchtNo长度不能超过15")
    private String mchtNo;

    /**
     * 设备编号
     * (选填)
     */
    @Length(max = 32, message = "deviceNo长度不能超过32")
    private String deviceNo;

    /**
     * 版本号
     * (必填)
     */
    @Length(max = 5, message = "version长度不能超过5")
    private String version;

    /**
     * 终端IP
     * (必填)
     */
    @Length(max = 64, message = "terminalIp长度不能超过64")
    private String terminalIp;

    /**
     * 终端编号
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 操作员编号
     * (选填)
     */
    @Length(max = 32, message = "opUserId长度不能超过32")
    private String opUserId;

    /**
     * 操作员名称
     * (选填)
     */
    @Length(max = 64, message = "opUserName长度不能超过64")
    private String opUserName;

    /**
     * 门店编号
     * (选填)
     */
    @Length(max = 32, message = "storeNo长度不能超过32")
    private String storeNo;

    /**
     * 请求方自定义字段
     * (选填)
     */
    @Length(max = 64, message = "reqReserved长度不能超过64")
    private String reqReserved;

    /**
     * 终端MAC地址，终端设备发起交易必传
     * (选填)
     */
    @Length(max = 100, message = "macAddr长度不能超过100")
    private String macAddr;
}