/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author wangqilei
 * @version FjnxBillApplyRequest.java, v 0.1 2024-12-04 11:21 AM wangqilei
 */
@Data
public class FjnxBillDownloadRequest extends FjnxBizRequest implements Serializable {
    private static final long serialVersionUID = 7407426197984496990L;

    /**
     * 账单服务
     *
     * 01-申请单个商户对账单
     * 02-申请一、二级商户对账单
     *
     * (必填)
     */
    @Length(max = 2, message = "billService长度不能超过2")
    private String billService;

    /**
     * 账单日期YYYYMMDD
     *
     * (必填)
     */
    @Length(max = 8, message = "billDate长度不能超过8")
    private String billDate;
}